import SpanElement from "../../../common/dom/element/SpanElement";
import IDataMigrationElementView from "./element/IDataMigrationElementView";
import ITagNode from "../../../common/xml/node/ITagNode";
import DomElement from "../../../common/dom/element/DomElement";
import AbstractDomElement from "../../../common/dom/AbstractDomElement";
import BaseConstants from "../../base/BaseConstants";
import {EHAlign, EVAlign} from "../../../common/enum/Enums";
import EXCEL from "../../excel/base/EXCEL";
import DATAMIGRATION from "../base/DATAMIGRATION";
import SizeInfo from "../../../common/struct/SizeInfo";
import DataMigrationConstants from "../base/DataMigrationConstants";
import {AddButton} from "../container/layout/AddButton";
import TextEditor from "../../../common/component/control/TextEditor";
import DataMigrationGraphicView from "./DataMigrationGraphicView";
import MoveTableState from "../state/MoveTableState";
import InputState from "../state/InputState";


export class FieldView extends SpanElement {

    private tagCell: ITagNode;
    private fieldType: string = "";

    private imageDomElement?: DomElement;
    private addButton?: AddButton;

    private textEditor?: TextEditor;

    constructor(tagCell: ITagNode) {
        super();
        this.tagCell = tagCell;
    }


    getTextEditor(): TextEditor {
        return this.textEditor!;
    }

    getImageDomElement(): DomElement {
        return this.imageDomElement!;
    }

    getDomElement(): AbstractDomElement {
        return this;
    }

    findChildNode(tagNode: ITagNode): IDataMigrationElementView | null {
        return null;
    }

    isEmbed(): boolean {
        return false;
    }

    containPoint(x: number, y: number): boolean {
        return false;
    }

    getTagNode(): ITagNode {
        return this.tagCell;
    }

    buildFirstView(caption: string | undefined): void {
        let dataMigration = this.tagCell.getParent()!;
        if (this.tagCell.getTagName() == "TargetTableCollection") {
            let targetKey = dataMigration.getAttributeValue("TgtDataObjectKey");
            this.setText("(目标)   " + targetKey + " " + caption);
        } else {
            let srcKey = dataMigration.getAttributeValue("SrcDataObjectKey");
            this.setText("(源)   " + srcKey + " " + caption);
        }
        var containerEl = this.parentEl();
        if (containerEl) {//td
            var container = new DomElement(containerEl);
            this.tagCell.isSelected() ? container.addClass('fieldselected') : container.removeClass('fieldselected');
            let rowNode = this.getTagNode().getParent();
            container.addClass('tableHead')
            this.setStyle('font-weight', 'bold');
            this.setStyle('font-size', '14px');
            this.setStyle('color', 'rgba(0,17,227,1)');
        }
    }

    /**
     * 更新单元格内容，并设置样式
     */
    updateView(cap: string | undefined, dataMigrationGraphicView: DataMigrationGraphicView, dataType: string, type: string): void {
        let caption = this.getCaption();
        if (caption == '') {
            caption = this.getFieldKey();
        }
        if (!caption) {
            cap = '';
        }
        if (cap) {
            this.fieldType = dataType;
        } else {
            cap = '';
        }
        this.setText(caption + " " + cap);
        var containerEl = this.getEl().parentElement;
        if (containerEl) {//td
            var container = new DomElement(containerEl);
            if (this.getTagNode().getTagName() == DataMigrationConstants.NODE_SourceTable /*|| this.getTagNode().getTagName() == DataMigrationConstants.NODE_TargetTable*/) {
                this.addButton = <AddButton>new AddButton(this.getTagNode(), dataMigrationGraphicView, this.getTagNode().getTagName());
                container.addChild(this.addButton.getDomElement())
            }
            if (!this.textEditor) {
                this.textEditor = new TextEditor();
                this.textEditor.setStyle("display", "none");
                var input = new DomElement(this.textEditor.getEl());
                container.addChild(input);
                var sefl = dataMigrationGraphicView;
                this.textEditor.addEventListener("blur", (e: any) => {
                    var target = <HTMLElement>e.target;
                    target.style.backgroundColor = "#DDDDDD";
                    sefl.initInputState(sefl, e);
                    setTimeout(function () {
                        sefl.getOptStateDelegate().setNormalState();
                    }, 100)
                });
                this.textEditor.addEventListener("focus", (e: any) => {
                    sefl.getOptStateDelegate().setInputState();
                });
            }
            this.tagCell.isSelected() ? container.removeClass('fieldCell') : container.addClass('fieldCell');
            this.tagCell.isSelected() ? container.addClass('fieldselected') : container.removeClass('fieldselected');
            if (this.tagCell.isSelected()) {
                let deleteButton = new DomElement(new Image(16, 16));
                deleteButton.addEventListener("click", (e: any) => {
                    sefl.initDeleteState(sefl, e);
                });
                deleteButton.setAttr("src", DATAMIGRATION.PREFIX + "/css/img/deleteButton.png");
                if (this.getTagNode().getTagName() == DataMigrationConstants.NODE_SourceTable) {
                    deleteButton.addClass("delete-button-table");
                } else {
                    deleteButton.addClass("delete-button-field");
                }
                container.addChild(deleteButton);
                this.imageDomElement = deleteButton;
            } else {
                if (this.imageDomElement) {
                    container.removeChild(this.imageDomElement);
                    this.imageDomElement = undefined;
                }
            }
            let rowNode = this.getTagNode().getParent();
            this.setStyle('font-weight', 'noraml');
            this.setStyle('font-size', '12px');
            if(type){
                this.setAttr("type", type);
            }
        }
    }

    getCaption(): string {
        if( this.tagCell.hasAttribute(DataMigrationConstants.NODE_Definition)) {
            return this.tagCell.getAttributeValue(DataMigrationConstants.NODE_Definition);
        }else{
            return this.tagCell.getAttributeValue(DataMigrationConstants.Attr_Key);
        }
    }

    getFieldKey(): string {
        return this.tagCell.getAttributeValue("FieldKey");
    }

    getKey(): string {
        return this.tagCell.getAttributeValue(BaseConstants.ATTR_Key);
    }

    getFieldType(): string {
        return this.fieldType;
    }
}


//ColumnExpand
/**
 *  <Display HAlign="Right" VAlign="Top">
 <Cell Caption="公式定义">
 <Display HAlign="Left">
 <Font Bold="true" Name="SimSun" Size="14"/>
 <Border BottomColor="#000000" BottomStyle="1" LeftColor="#000000" LeftStyle="1" RightColor="#000000" RightStyle="1" TopColor="#000000" TopStyle="1"/>
 </Display>
 </Cell>
 */