import IXmlEntity from "../../../common/xml/IXmlEntity";
import IPropertyItem from "../../plugin/property/base/PropertyDefine";
import PropertyIO from "../../plugin/property/base/PropertyIO";
import ITagNode from "../../../common/xml/node/ITagNode";
import {XMLElementType} from "../../../common/enum/Enums";
import DataMigrationGraphicView from "../view/DataMigrationGraphicView";
import DataMigrationConstants from "../base/DataMigrationConstants";

export class DataMigrationProperty extends PropertyIO {
    private dataMapGraphicView: DataMigrationGraphicView
    private xmlEntity: IXmlEntity

    constructor(xmlEntity: IXmlEntity, printGraphicView: DataMigrationGraphicView) {
        super(xmlEntity);
        this.xmlEntity = xmlEntity;
        this.dataMapGraphicView = printGraphicView
    }

    setValue(propertyItem: IPropertyItem, propertyValue: any): void {
        var proertyNode = this.ensureProertyNode(propertyItem, <ITagNode>this.curTagNode);
        if (this.curTagNode?.getTagName() == "Ligature") {//连接线属性的修改
            let child = this.curTagNode.getChildren()[0];
            proertyNode = this.ensureProertyNode(propertyItem, <ITagNode>child);
            if (proertyNode) {
                var tagNode = PropertyIO.setPropertyValue(proertyNode, propertyItem, propertyValue);
                tagNode && this.xmlEntity.update(tagNode, propertyItem.updateAttributeOnly);
            } else {
                super.setValue(propertyItem, propertyValue);
            }
        } else {
            if (proertyNode) {
                var tagNode = PropertyIO.setPropertyValue(proertyNode, propertyItem, propertyValue);
                tagNode && this.xmlEntity.update(tagNode, propertyItem.updateAttributeOnly);
            } else {
                if (propertyItem.key == "IsPrimary" && propertyValue == "true"){
                    let find = this.curTagNode?.getParent()?.find("SourceTable","IsPrimary","true");
                    if (find){
                        find.removeAttribute("IsPrimary");
                    }
                }
                //属性栏修改公式或常量，由于一对多的连线会导致xml中可能存在多个相同definition的节点，故单独设值
                if (propertyItem.key == DataMigrationConstants.Attr_Key || propertyItem.key == DataMigrationConstants.NODE_Definition  && propertyItem.editable == "true") {
                    this.setConstOrFormulaValue(propertyItem,propertyValue);
                }else{
                    super.setValue(propertyItem, propertyValue);
                }
            }
        }


    }

    getValue(propertyItem: IPropertyItem): any {
        var tagNode = this.ensureProertyNode(propertyItem, <ITagNode>this.curTagNode);
        if (tagNode) {
            var text = tagNode.getAttributeValue(propertyItem.textAttributeKey);
            switch (propertyItem.type) {
                case XMLElementType.ATTRIBUTE:
                    if (tagNode.hasAttribute(propertyItem.key)) {
                        return tagNode.getAttributeValue(propertyItem.key);
                    } else {
                        if (!text) {
                            return propertyItem.defaultvalue ? propertyItem.defaultvalue : "";
                        } else {
                            return text;
                        }
                    }
                case XMLElementType.CDATA:
                    var tmpNode = tagNode.getChild(propertyItem.key);
                    return tmpNode ? tmpNode.getCDATAValue() : "";
                case XMLElementType.COLLECTION:
                    var collection = tagNode.ensureChild(propertyItem.key);
                    return collection;
            }
        } else {
            return super.getValue(propertyItem);

        }
    }

    getDataMaptGraphicView(): DataMigrationGraphicView {
        return this.dataMapGraphicView;
    }

    private ensureProertyNode(propertyItem: IPropertyItem, curTagNode: ITagNode): ITagNode | null {
        var tagNode = null;
        if (propertyItem.tag != curTagNode.getTagName() && propertyItem.tag == "Ligature" && curTagNode.getTagName() == "SourceField") {//线处理
            tagNode = curTagNode;

        }
        return tagNode;
    }

    setConstOrFormulaValue(propertyItem: IPropertyItem, propertyValue: any) {
        let childs = this.curTagNode!.getParent()!.getChildren();
        let tagNode = this.curTagNode!;
        let fieldKey;
        if (tagNode.hasAttribute(DataMigrationConstants.NODE_Definition)) {
            fieldKey = tagNode.getAttributeValue(DataMigrationConstants.NODE_Definition);
        } else {
            fieldKey = tagNode.getAttributeValue(DataMigrationConstants.Attr_Key);
        }
        for (let i = 0; i < childs.length; i++) {
            let findTagNode = <ITagNode>childs[i];
            if (findTagNode.getAttributeValue(DataMigrationConstants.Attr_Key) == fieldKey) {
                findTagNode.setAttributeValue(DataMigrationConstants.Attr_Key, propertyValue);
            } else if (findTagNode.getAttributeValue(DataMigrationConstants.NODE_Definition) == fieldKey) {
                findTagNode.setAttributeValue(DataMigrationConstants.NODE_Definition, propertyValue);
                findTagNode.setAttributeValue(DataMigrationConstants.Attr_Key, findTagNode.getAttributeValue(DataMigrationConstants.Attr_Key, "").replace(fieldKey, propertyValue));
            }
        }
        this.xmlEntity.update(this.curTagNode!.getParent(), propertyItem.updateAttributeOnly);
    }
}