import ICmd from "../../../common/cmd/ICmd";
import IXmlEntity from "../../../common/xml/IXmlEntity";
import ITagNode from "../../../common/xml/node/ITagNode";
import XmlEntity from "../../../common/xml/XmlEntity";

export default class MoveTableCmd implements ICmd {

    // 新的坐标
    private x: number;
    private y: number;

    private tagNode: ITagNode;
    private newTarNode?: ITagNode;
    private oldTarNode?: ITagNode;
    private xmlEntity: IXmlEntity;

    constructor(xmlEntity: IXmlEntity, tagNode: ITagNode, x: number, y: number) {
        this.xmlEntity = xmlEntity;
        this.tagNode = tagNode;
        this.x = x;
        this.y = y;
    }

    do(): boolean {
        let tableCollection = this.tagNode;
        let node = tableCollection.toXml(true);
        this.oldTarNode = XmlEntity.parseTagNode(node);
        tableCollection.setAttributeValue("X", String(this.x));
        tableCollection.setAttributeValue("Y", String(this.y));
        this.newTarNode = tableCollection;
        this.xmlEntity.update(tableCollection, true);
        return true;
    }

    undo(): void {
        if (this.newTarNode) {
            this.newTarNode.setAttributeValue("X", this.oldTarNode!.getAttributeValue("X",), String(this.x));
            this.newTarNode.setAttributeValue("Y", this.oldTarNode!.getAttributeValue("Y",), String(this.y));
            this.xmlEntity.update(this.newTarNode, true);
        }
    }

}