import ICmd from "../../../common/cmd/ICmd";
import ITagNode from "../../../common/xml/node/ITagNode";
import IXmlEntity from "../../../common/xml/IXmlEntity";
import IWorkSpace from "../../../common/workspace/IWorkSpace";
import TagNode from "../../../common/xml/node/TagNode";
import XmlEntity from "../../../common/xml/XmlEntity";


export default class AddTargetFieldsCmd implements ICmd {


    private dataTable: any;
    private xmlEntity: IXmlEntity;
    private wfWorkSpace: IWorkSpace;

    private newTarNode?: ITagNode;
    private oldTarNode?: ITagNode;

    constructor(dataTable: any, xmlEntity: IXmlEntity, wfWorkSpace: IWorkSpace) {
        this.dataTable = dataTable;
        this.xmlEntity = xmlEntity;
        this.wfWorkSpace = wfWorkSpace;


    }

    do(): boolean {
        let datamigration = <ITagNode>this.xmlEntity.getRoot().getChildren()[1];
        let targetTableCollection = datamigration.getChild("TargetTableCollection");
        let node = targetTableCollection!.toXml(true);
        this.oldTarNode = XmlEntity.parseTagNode(node);
        for (let i = 0; i < this.dataTable.getRowCount(); i++) {
            this.dataTable.setPos(i);
            if (!this.dataTable.rows[i] || this.dataTable.getState() == 3)
                continue;
            let tableKey = this.dataTable.getByKey("TableKey");
            let fieldKey = this.dataTable.getByKey("FieldKey");
            let isSelectField = this.dataTable.getByKey("SelectField") == 1;
            if (!isSelectField) {
                continue;
            }

            let find = datamigration.find("TargetTable", "TableKey", tableKey);
            if (!find) {//没有这个表
                find = new TagNode("TargetTable");
                find.setAttributeValue("TableKey", tableKey);
                targetTableCollection?.addChild(find);
                let fieldNode = new TagNode("TargetField");
                fieldNode.setAttributeValue("FieldKey", fieldKey);
                find.addChild(fieldNode);
            } else {
                let fieldNode = new TagNode("TargetField");
                fieldNode.setAttributeValue("FieldKey", fieldKey);
                find.addChild(fieldNode);
            }
        }
        this.newTarNode = targetTableCollection!;
        this.xmlEntity.update(this.xmlEntity.getRoot(), true);
        this.wfWorkSpace.reloadSource();
        return true;

    }


    undo(): void {
        if (this.newTarNode) {
            let children = this.newTarNode.getChildren();
            let children1 = this.oldTarNode!.getChildren();
            let s
            while (s=children.pop()){
                if (!s){
                    break;
                }
            }
            for (let i = 0; i < children1.length; i++) {
                children1[i].setParent(this.newTarNode);
                children.push(children1[i]);
            }
        }
        this.xmlEntity.update(this.xmlEntity.getRoot(), true);
        this.wfWorkSpace.reloadSource();

    }

}