import {AbstractDataMapOptState} from "./AbstractDataMapOptState";
import {DataMapOptStateDelegate} from "./DataMapOptStateDelegate";
import {FieldRow} from "../view/element/FieldRow";
import {CommonConstant} from "../base/CommonConstant";

export class DataMapMoveTableState extends AbstractDataMapOptState{

    // 虚拟框
    private moveSelected: any;
    private formRow?: FieldRow;
    private ele?: MouseEvent;

    constructor(delegate: DataMapOptStateDelegate) {
        super(delegate);
    }

    init(row :FieldRow, e: MouseEvent, isMoving: boolean){
        this.formRow = row;
        this.ele = e;

        let tagNode = row.getTagNode();
        let width = tagNode.getAttributeValue(CommonConstant.ATTR_Width);
        let height = tagNode.getAttributeValue(CommonConstant.ATTR_Height);
        $('tdMoveSelected').remove();
        this.moveSelected = $('<div id= "tdMoveSelected" style= "position: relative;"></div>').hide();
        this.moveSelected.css('cursor','move');
        this.moveSelected.css('border','1px dashed black');
        this.moveSelected.css({width: width, height: height});
        this.moveSelected.appendTo($(this.getView().getEl()).find('svg').parent());
        let self = this;
        this.moveSelected.mousemove(function (e: MouseEvent) {
            self.mousemove(e);
        })
        
        this.moveSelected.mouseup(function (e: MouseEvent) {
            self.mouseup(e);
        })
    }

    mousedown(e: MouseEvent): void {
        let view = this.findFieldView(e);
        if(! view) return;
    }

    mousemove(e:MouseEvent){
        if(!this.ele) return;
        let x = this.ele.clientX;
        let y= this.ele.clientY;
        let tagNode = this.formRow!.getTagNode();
        let tableX = +tagNode.getAttributeValue(CommonConstant.ATTR_X);
        let tableY = +tagNode.getAttributeValue(CommonConstant.ATTR_Y);
        let relativeX = Math.abs(x - tableX);
        let relativeY = Math.abs(y - tableY);
        this.moveSelected.css({left: Math.abs(e.clientX - relativeX), top: Math.abs(e.clientY - relativeY)}).show();
    }

    mouseup(e: MouseEvent): void {
        let moveSelected = this.moveSelected;
        let relativeLeft = Math.abs(moveSelected.offset().left - moveSelected.parent().offset().left);
        let relativeTop = Math.abs(moveSelected.offset().top - moveSelected.parent().offset().top);
        this.getView().doMoveTableCmd(this.getView(), this.formRow!.getTagNode(), relativeLeft, relativeTop);
        this.reset();
        this.getDelegate().setNormalState();
    }

    reset(){
        this.formRow = undefined;
        this.ele = undefined;
        this.moveSelected.remove();
        this.moveSelected = undefined;
    }

}