import IXmlEntity from "../../../common/xml/IXmlEntity";
import IPropertyItem from "../../plugin/property/base/PropertyDefine";
import PropertyIO from "../../plugin/property/base/PropertyIO";
import ITagNode from "../../../common/xml/node/ITagNode";
import {XMLElementType} from "../../../common/enum/Enums";
import {DataMapGraphicView} from "../view/DataMapGraphicView";
import {CommonConstant} from "../base/CommonConstant";
import {CommonFunction} from "../base/CommonFunction";
import XmlEntity from "../../../common/xml/XmlEntity";

export class DataMapProperty extends PropertyIO {
    private dataMapGraphicView: DataMapGraphicView
    private xmlEntity: IXmlEntity

    constructor(xmlEntity: IXmlEntity, printGraphicView: DataMapGraphicView) {
        super(xmlEntity);
        this.xmlEntity = xmlEntity;
        this.dataMapGraphicView = printGraphicView
    }

    setValue(propertyItem: IPropertyItem, propertyValue: any): void {
        var proertyNode = this.ensurePropertyNode(propertyItem, <ITagNode>this.curTagNode);
        if (this.curTagNode?.getTagName() == "Ligature" || this.curTagNode?.getTagName() == CommonConstant.NODE_FEEDBACK) {//连接线属性的修改
            let child = this.curTagNode.getChildren()[0];
            proertyNode = this.ensurePropertyNode(propertyItem, <ITagNode>child);
            if(propertyItem.key == "EdgeType"){
                //当关系线类型为普通映射时，去除是否负向映射属性
                if(propertyValue == CommonConstant.EdgeType_Normal) {
                    if (proertyNode!.hasAttribute("IsNegtive")) {
                        proertyNode!.removeAttribute("IsNegtive");
                    }
                }
                //当关系线类型为关注映射时，去除字段下推条件属性
                else if(propertyValue == CommonConstant.EdgeType_Focus){
                    if (proertyNode!.hasAttribute(CommonConstant.NODE_Condition)) {
                        proertyNode!.removeAttribute(CommonConstant.NODE_Condition);
                    }
                }
                var tagNode = PropertyIO.setPropertyValue(proertyNode!, propertyItem, propertyValue);
                tagNode && this.xmlEntity.update(tagNode, propertyItem.updateAttributeOnly);
            }
            else if (proertyNode) {
                var tagNode = PropertyIO.setPropertyValue(proertyNode, propertyItem, propertyValue);
                tagNode && this.xmlEntity.update(tagNode, propertyItem.updateAttributeOnly);
            } else {
                super.setValue(propertyItem, propertyValue);
            }
        } else {
            if (proertyNode) {
                var tagNode = PropertyIO.setPropertyValue(proertyNode, propertyItem, propertyValue);
                tagNode && this.xmlEntity.update(tagNode, propertyItem.updateAttributeOnly);
            } else {
                //条件中三个属性加在FeedbackCollection节点上而非TargetTableCollection
                if (propertyItem.tag == CommonConstant.NODE_TargetTableCollection && (propertyItem.key == "StatusFieldKey" || propertyItem.key == "StatusValue" || propertyItem.key == "Condition")) {
                    this.setFeedValue(propertyItem, propertyValue);
                }
                //属性栏修改公式或常量，由于一对多的连线会导致xml中可能存在多个相同definition的节点，故单独设值
                else if (propertyItem.key == CommonConstant.S_Key || propertyItem.key == CommonConstant.NODE_Definition  && propertyItem.editable == "true") {
                   this.setConstOrFormulaValue(propertyItem,propertyValue);
                }
                else {
                    //当设置当前选择表为主表时，去除当前表单其它表主表及下推执行条件属性
                    if (propertyItem.key == "IsPrimary" && propertyValue == "true") {
                        let parent = this.curTagNode?.getParent();
                        let childs = parent!.getChildren();
                        for (let child of childs) {
                            let tagNode = <ITagNode>child;
                            if (tagNode.hasAttribute(CommonConstant.ATTR_IsPrimary)) {
                                tagNode.removeAttribute(CommonConstant.ATTR_IsPrimary);
                                if (tagNode.hasAttribute(CommonConstant.NODE_Condition)) {
                                    tagNode.removeAttribute(CommonConstant.NODE_Condition);
                                }
                            }
                        }
                    }
                    //当前表由主表改为非主表时，删除下推执行条件属性
                    else if (propertyItem.key == "IsPrimary" && propertyValue == "false") {
                        if (this.curTagNode!.hasAttribute(CommonConstant.NODE_Condition)) {
                            this.curTagNode!.removeAttribute(CommonConstant.NODE_Condition);
                        }
                    }
                    if(propertyItem.tag == CommonConstant.NODE_SourceTable && propertyItem.key == CommonConstant.ATTR_Type && propertyValue == CommonConstant.NODE_Table){
                        if (this.curTagNode!.hasAttribute(CommonConstant.ATTR_DataSource)) {
                            this.curTagNode!.removeAttribute(CommonConstant.ATTR_DataSource);
                        }
                        if(this.curTagNode!.hasAttribute(CommonConstant.ATTR_EntityFormKey)){
                            this.curTagNode!.removeAttribute(CommonConstant.ATTR_EntityFormKey);
                        }
                    }
                    super.setValue(propertyItem, propertyValue);
                }
            }
        }
    }

    setConstOrFormulaValue(propertyItem: IPropertyItem, propertyValue: any){
        let childs = this.curTagNode!.getParent()!.getChildren();
        let tagNode = this.curTagNode!;
        let fieldKey;
        if(propertyItem.tag == CommonConstant.NODE_SourceField && !tagNode.hasAttribute(CommonConstant.NODE_Definition)) {
            fieldKey = tagNode.getAttributeValue(CommonConstant.S_Key);
        }else{
            fieldKey = tagNode.getAttributeValue(CommonConstant.NODE_Definition);
        }
        //查询修改的值是否已经存在
        if(!CommonFunction.hasField(this.curTagNode!, propertyValue, this.xmlEntity)) {
            for (let i = 0; i < childs.length; i++) {
                let findTagNode = <ITagNode>childs[i];
                if (tagNode.getTagName() == CommonConstant.NODE_SourceField) {
                    if (findTagNode.getAttributeValue(CommonConstant.S_Key) == fieldKey) {
                        findTagNode.setAttributeValue(CommonConstant.S_Key, propertyValue);
                    } else if (findTagNode.getAttributeValue(CommonConstant.NODE_Definition) == fieldKey) {
                        findTagNode.setAttributeValue(CommonConstant.NODE_Definition, propertyValue);
                        findTagNode.setAttributeValue(CommonConstant.S_Key, findTagNode.getAttributeValue(CommonConstant.S_Key, "").replace(fieldKey, propertyValue));
                    }
                } else {
                    if (findTagNode.getAttributeValue(CommonConstant.NODE_Definition) == fieldKey) {
                        findTagNode.setAttributeValue(CommonConstant.NODE_Definition, propertyValue);
                    }
                }
            }
            if (propertyItem.tag == CommonConstant.NODE_TargetField) {
                let tableKey = this.curTagNode!.getParent()!.getAttributeValue(CommonConstant.S_Key);
                let mapChilds = this.xmlEntity.getTagRoot().getChildren();
                for (let i = 0; i < mapChilds.length; i++) {
                    let mapChild = <ITagNode>mapChilds[i];
                    if (!(mapChild.getTagName() == CommonConstant.NODE_SourceTableCollection)) continue;
                    let sourceTables = mapChild.getChildren();
                    for (let j = 0; j < sourceTables.length; j++) {
                        let sourceTable = <ITagNode>sourceTables[j];
                        let sourceFields = sourceTable.getChildren();
                        for (let k = 0; k < sourceFields.length; k++) {
                            let sourceField = <ITagNode>sourceFields[k];
                            let targetFieldKey = sourceField.getAttributeValue(CommonConstant.NODE_TargetFieldKey);
                            if (sourceField.hasAttribute(CommonConstant.NODE_TargetTableKey)) {
                                if (sourceField.getAttributeValue(CommonConstant.NODE_TargetTableKey) == tableKey && targetFieldKey == fieldKey) {
                                    sourceField.setAttributeValue(CommonConstant.NODE_TargetFieldKey, propertyValue);
                                }
                            } else {
                                if (sourceField.hasAttribute(CommonConstant.NODE_TargetFieldKey)) {
                                    if (targetFieldKey == fieldKey) {
                                        sourceField.setAttributeValue(CommonConstant.NODE_TargetFieldKey, propertyValue);
                                    }
                                }
                            }
                        }
                    }
                }
                this.xmlEntity.update(this.xmlEntity.getTagRoot(), propertyItem.updateAttributeOnly);
            } else {
                this.xmlEntity.update(this.curTagNode!.getParent(), propertyItem.updateAttributeOnly);
            }
        }

    }

    setFeedValue(propertyItem: IPropertyItem, propertyValue: any){
        let rootChilds = this.xmlEntity.getTagRoot().getChildren();
        for(let i = 0 ; i < rootChilds.length; i++){
            let node = <ITagNode>rootChilds[i];
            if(node.getTagName() == CommonConstant.NODE_FeedbackCollection){
                var tagNode = PropertyIO.setPropertyValue(node, propertyItem, propertyValue);
                tagNode && this.xmlEntity.update(tagNode, propertyItem.updateAttributeOnly);
            }
        }

    }

    getSourceTableKey(propertyItem: IPropertyItem): any{
        if(!this.curTagNode!.hasAttribute(CommonConstant.ATTR_SourceTableKey)){
           return this.curTagNode!.getAttributeValue(CommonConstant.S_Key,"");
        }
        return super.getValue(propertyItem);
    }

    getFeedValue(propertyItem: IPropertyItem): any {
        if (!this.curTagNode) return "";
        let rootChilds = this.xmlEntity.getTagRoot().getChildren();
        for(let i = 0 ; i < rootChilds.length; i++){
            let node = <ITagNode>rootChilds[i];
            if(node.getTagName() == CommonConstant.NODE_FeedbackCollection){
                var tagNode = PropertyIO.ensureProertyNode(propertyItem, node);
                var text = tagNode.getAttributeValue(propertyItem.textAttributeKey);
                switch (propertyItem.type) {
                    case XMLElementType.ATTRIBUTE:
                        let key = propertyItem.key;
                        if(key == "sourceContent"){
                            key = "Definition";
                        }
                        if (tagNode.hasAttribute(key)) {
                            return tagNode.getAttributeValue(key);
                        } else {
                            if (!text) {
                                return propertyItem.defaultvalue ? propertyItem.defaultvalue : "";
                            } else {
                                return text;
                            }
                        }
                    case XMLElementType.CDATA:
                        var tmpNode = tagNode.getChild(propertyItem.key);
                        return tmpNode ? tmpNode.getCDATAValue(): "";
                    case XMLElementType.COLLECTION:
                        var collection = tagNode.ensureChild(propertyItem.key);
                        return collection;
                }
            }
        }
        return propertyItem.defaultvalue;

    }

    getValue(propertyItem: IPropertyItem): any {
        var tagNode = this.ensurePropertyNode(propertyItem, <ITagNode>this.curTagNode);
        if (tagNode) {
            var text = tagNode.getAttributeValue(propertyItem.textAttributeKey);
            switch (propertyItem.type) {
                case XMLElementType.ATTRIBUTE:
                    if (tagNode.hasAttribute(propertyItem.key)) {
                        return tagNode.getAttributeValue(propertyItem.key);
                    } else {
                        if (!text) {
                            return propertyItem.defaultvalue ? propertyItem.defaultvalue : "";
                        } else {
                            return text;
                        }
                    }
                case XMLElementType.CDATA:
                    if(this.curTagNode?.getTagName() == CommonConstant.NODE_FEEDBACK){
                        var tmpNode = (<ITagNode>tagNode.getChildren()[0]).getChild(propertyItem.key);
                        return tmpNode ? tmpNode.getCDATAValue() : "";
                    }else {
                        var tmpNode = tagNode.getChild(propertyItem.key);
                        return tmpNode ? tmpNode.getCDATAValue() : "";
                    }
                case XMLElementType.COLLECTION:
                    var collection = tagNode.ensureChild(propertyItem.key);
                    return collection;
            }
        } else {
            if (propertyItem.tag == CommonConstant.NODE_TargetTableCollection && (propertyItem.key == "StatusFieldKey" || propertyItem.key == "StatusValue" || propertyItem.key == "Condition")) {
                return this.getFeedValue(propertyItem);
            }
            if(propertyItem.tag == CommonConstant.NODE_SourceTable && propertyItem.key == CommonConstant.ATTR_SourceTableKey){
                return this.getSourceTableKey(propertyItem);
            }
            return super.getValue(propertyItem);

        }
    }

    private ensurePropertyNode(propertyItem: IPropertyItem, curTagNode: ITagNode): ITagNode | null {
        var tagNode = null;
        if (propertyItem.tag != curTagNode.getTagName() &&
            (
                (propertyItem.tag == "Ligature" && curTagNode.getTagName() == "SourceField")
                ||
                (propertyItem.tag == CommonConstant.FeedLigature && curTagNode.getTagName() == CommonConstant.NODE_FEEDBACK)
            )
        ){//线处理
            tagNode = curTagNode;
        }
        return tagNode;
    }
}