import ICmd from "../../../common/cmd/ICmd";
import ITagNode from "../../../common/xml/node/ITagNode";
import IXmlEntity from "../../../common/xml/IXmlEntity";
import IWorkSpace from "../../../common/workspace/IWorkSpace";
import TagNode from "../../../common/xml/node/TagNode";
import XmlEntity from "../../../common/xml/XmlEntity";
import {CommonConstant} from "../base/CommonConstant";


export default class AddTargetFieldsCmd implements ICmd {


    private dataTable: any;
    private xmlEntity: IXmlEntity;
    private wfWorkSpace: IWorkSpace;

    private newTarNode?: ITagNode;
    private oldTarNode?: ITagNode;

    constructor(dataTable: any, xmlEntity: IXmlEntity, wfWorkSpace: IWorkSpace) {
        this.dataTable = dataTable;
        this.xmlEntity = xmlEntity;
        this.wfWorkSpace = wfWorkSpace;


    }

    do(): boolean {
        let datamap = <ITagNode>this.xmlEntity.getRoot().getChildren()[1];
        let targetTableCollection = datamap.getChild(CommonConstant.NODE_TargetTableCollection);
        let node = targetTableCollection!.toXml(true);
        this.oldTarNode = XmlEntity.parseTagNode(node);
        for (let i = 0; i < this.dataTable.getRowCount(); i++) {
            this.dataTable.setPos(i);
            if (!this.dataTable.rows[i] || this.dataTable.getState() == 3)
                continue;
            let tableKey = this.dataTable.getByKey("TableKey");
            let fieldKey = this.dataTable.getByKey("FieldKey");
            let isSelectField = this.dataTable.getByKey("SelectField") == 1;
            if (!isSelectField) {
                continue;
            }

            let find = datamap.find(CommonConstant.NODE_TargetTable, CommonConstant.NODE_Table_Key, tableKey);
            if (!find) {//没有这个表
                find = new TagNode(CommonConstant.NODE_TargetTable);
                find.setAttributeValue(CommonConstant.NODE_Table_Key, tableKey);
                //find.setAttributeValue(CommonConstant.NODE_Type, "Table");
                //find.setAttributeValue(CommonConstant.ATTR_DataSource, tableKey);
                targetTableCollection?.addChild(find);
                let fieldNode = new TagNode(CommonConstant.NODE_TargetField);
                fieldNode.setAttributeValue(CommonConstant.NODE_Definition, fieldKey);
                find.addChild(fieldNode);
            } else {
                let fieldNode = new TagNode(CommonConstant.NODE_TargetField);
                fieldNode.setAttributeValue(CommonConstant.NODE_Definition, fieldKey);
                find.addChild(fieldNode);
            }
        }
        this.newTarNode = targetTableCollection!;
        this.xmlEntity.update(this.xmlEntity.getRoot(), true);
        this.wfWorkSpace.reloadSource();
        return true;

    }


    undo(): void {
        if (this.newTarNode) {
            let children = this.newTarNode.getChildren();
            let children1 = this.oldTarNode!.getChildren();
            let s
            while (s=children.pop()){
                if (!s){
                    break;
                }
            }
            for (let i = 0; i < children1.length; i++) {
                children1[i].setParent(this.newTarNode);
                children.push(children1[i]);
            }
        }
        this.xmlEntity.update(this.xmlEntity.getRoot(), true);
        this.wfWorkSpace.reloadSource();

    }

}