export default class DATAMAP {
    public static PREFIX = "designer";//".""designer"
    public static D_ROW_HEIGHT = 30;


    public static PROPERTIES_XML: string =
        `<DATAMAP>
<DefineCollection>
    <Define Key="Map" Caption="基础属性" Extends="">
        <PropertyCollection>
            <Property Key="Key" Caption="映射标识" Control="DataMapTextEditor" Editable = "false"/>
            <Property Key="Caption" Caption="映射说明" Control="DataMapTextEditor"/>
            <Property Key="Description" Caption="映射描述" Control="DataMapTextEditor"/>
            <Property Key="SrcFormKey" Caption="映射源表标识" Control="DataMapTextEditor" Editable = "false" />
            <Property Key="TgtFormKey" Caption="映射目标表标识" Control="DataMapTextEditor" Editable = "false" />
            <Property Key="MapRelationValue" Caption="允许关系值下推" Control="Combobox" OnInitialize="true,是;false,否" DefaultValue="true"/>
            <Property Key="MaxPushValue" Caption="总体最大下推值" Control="DataMapTextEditor" Editable = "true"/>
            <Property Key="MaxCurPushValue" Caption="单次最大下推值" Control="DataMapTextEditor" Editable = "true"/>
            <Property Key="MinPushValue" Caption="单次最小下推值" Control="DataMapTextEditor" Editable = "true"/>
            <Property Key="AllowSurplus" Caption="是否允许超量" Control="Combobox" OnInitialize="true,是;false,否" DefaultValue="false"/>
            <Property Key="RemainderPushValue" Caption="剩余下推量" Control="ButtonEditor"  OnButtonClick='Macro_ShowFormulaDialog("{self.key}",{{self.value}})'/>
            <Property Key="AllowRemainderPush" Caption="允许余量下推" Control="Combobox" OnInitialize="true,是;false,否" DefaultValue="true"/>
            <Property Key="MapCondition" Caption="映射执行条件" Control="ButtonEditor" OnButtonClick='Macro_ShowFormulaDialog("{self.key}",{{self.value}})'/>
            <Property Key="PullDataOnly" Caption="仅推送数据" Control="Combobox" OnInitialize="true,是;false,否" DefaultValue="false"/>
            <Property Key="MarkMapCount" Caption="源单上记录数据条数" Control="Combobox" OnInitialize="true,是;false,否" DefaultValue="true"/>
            <Property Key="PostProcess" Caption="映射执行后事件" Control="ButtonEditor" Type="CDATA" OnButtonClick='Macro_ShowFormulaDialog("{self.key}",{{self.value}})'/>
        </PropertyCollection>
    </Define>
    <Define Key="SourceTableCollection" Caption="源表集合" Extends="">
        <PropertyCollection>
            <Property Key="X" Caption="水平位置" Control="NumberEditor" />
            <Property Key="Y" Caption="垂直位置" Control="NumberEditor" />
            <Property Key="Width" Caption="宽度" Control="NumberEditor"/>
            <Property Key="Height" Caption="高度" Control="NumberEditor"/>
            <Property Key="Key" Caption="源表单标识" Control="DataMapTextEditor" Editable="false"  Group="源数据对象属性" DefaultValue="=GetDataMapRootAttrValue('SrcDataObjectKey')"/>
            <Property Key="sourceCaption" Caption="源表单说明" Control="DataMapTextEditor" Editable="false" Group="源数据对象属性" DefaultValue="=Macro_GetCaptionByDataObjectKey(GetDataMapRootAttrValue('SrcFormKey'),GetDataMapRootAttrValue('SrcDataObjectKey'))"/>
        </PropertyCollection>
    </Define>
    <Define Key="SourceTable" Caption="源表" Extends="">
        <PropertyCollection>
            <Property Key="Key" Caption="标识" Control="DataMapTextEditor" Editable="false"/>
            <Property Key="SourceTableKey" Caption="源表标识" Control="DataMapTextEditor" Editable="false"/>
            <Property Key="Caption" Caption="源表说明" Control="DataMapTextEditor" Editable="false" DefaultValue="=Macro_GetTableCaption(GetDataMapRootAttrValue('SrcFormKey'),GetDataMapTableKey())"/>
            <Property Key="TargetTableKey" Caption="目标表标识" Control="Combobox" OnInitialize="=GetTargetTableList()"/>
            <Property Key="IsPrimary" Caption="是否主表" Control="Combobox" OnInitialize="true,是;false,否" DefaultValue="false"/>
            <Property Key="Condition" Caption="下推执行条件" Control="ButtonEditor" Visible="GetPropertyValue('IsPrimary', 'false') == 'true'" OnButtonClick='Macro_ShowFormulaDialog("{self.key}",{{self.value}})'/>
            <Property Key="Type" Caption="来源类型" Control="Combobox" OnInitialize="Table,Table;SERVICE,SERVICE" DefaultValue="Table"/>
            <Property Key="DataSource" Caption="来源定义" Control="ButtonEditor" Visible="GetPropertyValue('Type', 'Table') == 'SERVICE'" OnButtonClick='ShowFormulaDialog("{self.key}",{{self.value}})'/>
            <Property Key="EntityFormKey" Caption="实体表单标识" Control="DataMapTextEditor" Visible="GetPropertyValue('Type', 'Table') == 'SERVICE'"/>
        </PropertyCollection>
    </Define>
    <Define Key="SourceField" Caption="源表字段" Extends="">
        <PropertyCollection>
            <Property Key="Key" Caption="源字段标识" Control="DataMapTextEditor" Editable="false" Visible="GetPropertyValue('Type', 'Field')=='Field' && !HasAttrDefinition()"/>
            <Property Key="Definition" Caption="源字段标识" Control="DataMapTextEditor" Editable="false" Visible="GetPropertyValue('Type', 'Field')=='Field' && HasAttrDefinition()"/>
            <Property Key="Key" Caption="源字段内容" Control="DataMapTextEditor" Editable="true" Visible="GetPropertyValue('Type', 'Field') !='Field'  && !HasAttrDefinition()"/>
            <Property Key="Definition" Caption="源字段内容" Control="DataMapTextEditor" Editable="true" Visible="GetPropertyValue('Type', 'Field') !='Field' && HasAttrDefinition()"/>
            <Property Key="Caption" Caption="源字段说明" Control="DataMapTextEditor" Editable="false" Visible="GetPropertyValue('Type', 'Field')=='Field'" DefaultValue="=Macro_GetCaptionByComponentKey(GetDataMapRootAttrValue('SrcFormKey'),GetDataMapTableKey(),GetDataMapFieldKey())" DefaultValue=""/>
            <Property Key="DataType" Caption="源字段数据类型" Control="DataMapTextEditor" Editable = "false" Visible="GetPropertyValue('Type', 'Field')=='Field'" DefaultValue="=Macro_GetDataType(GetDataMapRootAttrValue('SrcFormKey'),GetDataMapTableKey(),GetDataMapFieldKey())" DefaultValue=""/> 
            <Property Key="Type" Caption="源字段类型" Control="Combobox" DefaultValue="Field" OnInitialize="Field,字段;Formula,公式;Const,常量"  Editable = "false"/>
            <Property Key="RefFieldKey" Caption="参照的主表字段标识" Control="Combobox"  Visible="IsMainTable()!='true'" OnInitialize="=Macro_GetRefField(GetDataMapRootAttrValue('SrcFormKey'), GetPrimaryTableKey())" />
        </PropertyCollection>
    </Define>
    <Define Key="TargetTableCollection" Caption="目标表集合" Extends="">
        <PropertyCollection>
            <Property Key="X" Caption="水平位置" Control="NumberEditor" />
            <Property Key="Y" Caption="垂直位置" Control="NumberEditor" />
            <Property Key="Width" Caption="宽度" Control="NumberEditor"/>
            <Property Key="Height" Caption="高度" Control="NumberEditor"/>
            <Property Key="Key" Caption="目标表单标识" Control="DataMapTextEditor" Editable="false"  Group="目标数据对象属性" DefaultValue="=GetDataMapRootAttrValue('TgtDataObjectKey')"/>
            <Property Key="sourceCaption" Caption="目标表单说明" Control="DataMapTextEditor" Editable="false" Group="目标数据对象属性"  DefaultValue="=Macro_GetCaptionByDataObjectKey(GetDataMapRootAttrValue('TgtFormKey'),GetDataMapRootAttrValue('TgtDataObjectKey'))"/>
            <Property Key="StatusFieldKey" Caption="反填状态字段标识" Control="DataMapTextEditor" Visible="HasFeedBackCollection()" Editable="true" Group="目标数据对象属性"  DefaultValue=""/>
            <Property Key="StatusValue" Caption="反填状态值" Control="DataMapTextEditor" Visible="HasFeedBackCollection()" Editable="true" Group="目标数据对象属性"  DefaultValue=""/>
            <Property Key="Condition" Caption="反填数据条件" Control="ButtonEditor" Visible="HasFeedBackCollection()" Editable="true" Group="目标数据对象属性"  OnButtonClick='Macro_ShowFormulaDialog("{self.key}",{{self.value}})'/>
        </PropertyCollection>
    </Define>
    <Define Key="TargetTable" Caption="目标表" Extends="">
        <PropertyCollection>
            <Property Key="Key" Caption="目标表标识" Control="DataMapTextEditor" Editable = "false"/>
            <Property Key="Caption" Caption="目标表说明" Control="DataMapTextEditor" Editable="false" DefaultValue="=Macro_GetTableCaption(GetDataMapRootAttrValue('TgtFormKey'),GetDataMapTableKey())"/>
            <Property Key="IsPrimary" Caption="是否主表" Control="Combobox" OnInitialize="true,是;false,否" DefaultValue="false"/>
            <Property Key="RowTrigger" Caption="行触发" Control="ButtonEditor"  OnButtonClick='Macro_ShowFormulaDialog("{self.key}",{{self.value}})'/>
        </PropertyCollection>
    </Define>
    <Define Key="TargetField" Caption="目标表字段" Extends="">
        <PropertyCollection>
            <Property Key="Definition" Caption="目标字段标识" Control="DataMapTextEditor" Visible="GetPropertyValue('Type', 'Field')=='Field'" Editable = "false"/>
            <Property Key="Definition" Caption="目标字段内容" Control="DataMapTextEditor" Editable="true" Visible="GetPropertyValue('Type', 'Field') !='Field'"/>
            <Property Key="Caption" Caption="目标字段说明" Control="DataMapTextEditor" Editable="false" Visible="GetPropertyValue('Type', 'Field')=='Field'" DefaultValue="=Macro_GetCaptionByComponentKey(GetDataMapRootAttrValue('TgtFormKey'),GetDataMapTableKey(),GetDataMapFieldKey())" />
            <Property Key="DataType" Caption="目标字段数据类型" Control="DataMapTextEditor" Editable = "false" Visible="GetPropertyValue('Type', 'Field')=='Field'"  DefaultValue="=Macro_GetDataType(GetDataMapRootAttrValue('TgtFormKey'),GetDataMapTableKey(),GetDataMapFieldKey())"/>
            <Property Key="Type" Caption="目标字段类型" Control="Combobox"  DefaultValue="Field" OnInitialize="Field,字段;Formula,公式;Const,常量"  Editable = "false"/>
        </PropertyCollection>
    </Define>
    <Define Key="FeedbackObject" Caption="反填表单属性" Extends="">
        <PropertyCollection>
            <Property Key="FormKey" Caption="反填表单标识" Control="DataMapTextEditor" Editable = "false"/>
            <Property Key="Caption" Caption="反填表单说明" Control="DataMapTextEditor" Editable = "false"  DefaultValue="=Macro_GetTableCaption(GetPropertyValue('FormKey'),'')"/>
        </PropertyCollection>
    </Define>
    <Define Key="FeedbackTable" Caption="反填表属性" Extends="">
        <PropertyCollection>
            <Property Key="TableKey" Caption="反填表标识" Control="DataMapTextEditor" Editable = "false"/>
            <Property Key="Caption" Caption="反填表说明" Control="DataMapTextEditor" Editable = "false"  DefaultValue="=Macro_GetTableCaption(GetFeedbackFormKey(GetPropertyValue('TableKey')),GetPropertyValue('TableKey'))"/>
        </PropertyCollection>
    </Define>
    <Define Key="FeedbackField" Caption="反填字段属性" Extends="">
        <PropertyCollection>
            <Property Key="FieldKey" Caption="反填字段标识" Control="DataMapTextEditor" Editable = "false"/>
            <Property Key="Caption" Caption="反填字段说明" Control="DataMapTextEditor" Editable="false" DefaultValue="=Macro_GetCaptionByComponentKey(GetDataMapFormKeyByField(),GetDataMapTableKey(),GetPropertyValue('FieldKey'))"/>
            <Property Key="DataType" Caption="反填字段数据类型" Control="DataMapTextEditor" Editable = "false"   DefaultValue="=Macro_GetDataType(GetDataMapFormKeyByField(),GetDataMapTableKey(),GetPropertyValue('FieldKey'))"/>
        </PropertyCollection>
    </Define> 
    <Define Key="Ligature" Caption="连接线属性" Extends="">
        <PropertyCollection>
            <Property Key="Key" Caption="源字段key" Control="DataMapTextEditor" Editable = "false"/>
            <Property Key="FieldKey" Caption="源字段标识" Control="DataMapTextEditor" Editable = "false"/>
            <Property Key="Caption" Caption="源字段说明" Control="DataMapTextEditor" Editable="false" />
            <Property Key="TargetFieldKey" Caption="目标字段标识" Control="DataMapTextEditor" Editable = "false"/>
            <Property Key="TargetFieldCaption" Caption="目标字段说明" Control="DataMapTextEditor" Editable = "false"/>
            <Property Key="TargetTableKey" Caption="目标表标识" Control="DataMapTextEditor" Editable = "false"/>
            <Property Key="Editable" Caption="下推目标是否可编辑" Control="Combobox" OnInitialize="true,是;false,否" DefaultValue="true"/>
            <Property Key="EdgeType" Caption="关系线类型" Control="Combobox"  DefaultValue="Normal" OnInitialize="Normal,普通映射;Focus,关注映射;QUANTITYFOCUS_QUANTITY,QUANTITYFOCUS_QUANTITY;QUANTITYFOCUS_UNITID,QUANTITYFOCUS_UNITID;QUANTITYFOCUS_BASEQUANTITY,QUANTITYFOCUS_BASEQUANTITY;QUANTITYFOCUS_BASEUNITID,QUANTITYFOCUS_BASEUNITID;QUANTITYFOCUS_NUMERATOR,QUANTITYFOCUS_NUMERATOR;QUANTITYFOCUS_DENOMINATOR,QUANTITYFOCUS_DENOMINATOR"/>
            <Property Key="Condition" Caption="字段下推条件" Control="ButtonEditor" Visible="GetPropertyValueByCondition('EdgeType', 'Normal')=='Normal'" OnButtonClick='Macro_ShowFormulaDialog("{self.key}",{{self.value}})'/>
            <Property Key="IsNegtive" Caption="是否负向映射" Control="Combobox" Visible="GetPropertyValueByCondition('EdgeType', 'Normal')=='Focus'" OnInitialize="true,是;false,否" DefaultValue="false"/>
           <!-- <Property Key="SourceTypeKey" Caption="字段覆盖" Control="Combobox" Visible="GetDataMapRootAttrValue('Extend')!=''" OnInitialize="=Macro_GetSourceTypeValue(GetPropertyValue('TableKey', ''))"/>-->
        </PropertyCollection>
    </Define>
    <Define Key="FeedLigature" Caption="连接线属性" Extends="">
        <PropertyCollection>
            <Property Key="FeedFormKey" Caption="反填目标表单标识" Control="DataMapTextEditor" Editable = "false"/>
            <Property Key="TableKey" Caption="反填目标表标识" Control="DataMapTextEditor" Editable="false" />
            <Property Key="FieldKey" Caption="反填目标字段标识" Control="DataMapTextEditor" Editable = "false"/>
            <Property Key="FeedFieldCaption" Caption="反填目标字段说明" Control="DataMapTextEditor" Editable = "false"/>
            <Property Key="TargetFieldKey" Caption="反填目标源字段标识" Control="DataMapTextEditor" Editable = "false"/>
            <Property Key="TargetFieldCaption" Caption="反填目标源字段说明" Control="DataMapTextEditor" Editable = "false"/>
            <Property Key="OpSign" Caption="映射数据的处理方式" Control="Combobox" OnInitialize="Assign,赋直接量;AddDelta,加变化值" DefaultValue="Assign"/>
            <Property Key="PostTrigger" Caption="反填后期处理类" Control="ButtonEditor" Type="CDATA" OnButtonClick='Macro_ShowFormulaDialog("{self.key}",{{self.value}})'/>
            <Property Key="PostFormulaTrigger" Caption="反填后期处理公式" Control="ButtonEditor" Type="CDATA" OnButtonClick='Macro_ShowFormulaDialog("{self.key}",{{self.value}})'/>
            <Property Key="Condition" Caption="反填条件" Control="ButtonEditor" OnButtonClick='Macro_ShowFormulaDialog("{self.key}",{{self.value}})'/>
        </PropertyCollection>
    </Define>
</DefineCollection>
</DATAMAP>
`;
}