
import IGElement from "../../../../../../common/ui/graphic/IGElement";
import IGSection from "../../../../../../common/ui/graphic/IGSection";
import ITagNode from "../../../../../../common/xml/node/ITagNode";
import WfDefines from "../../../../base/WfDefines";
import AbstractNode from "../AbstractNode";

export default abstract class BaseDiamondNode extends AbstractNode {

    constructor(xmlNode?: ITagNode) {
        super(xmlNode);
    }

    public drawGraphic(gSection: IGSection): IGElement {
        var rw = 25,
            rh = 25;
        var polygon = gSection.polygon([0, rh, rw, 0, 2 * rw, rh, rw, 2*rh, 0, rh]).attr({
            fill: '#fff',
            stroke: '#000',
            'fill-opacity': '0.1',
            'strokeWidth': 1
        });
        return polygon;
    }

    protected drawCaption(): IGElement {
        var bounds = this.getBounds();
        var caption = this.getCaption();
        var text = this.gSection.text(bounds.width / 2, bounds.height + 18, caption);
        text.attr({'text-anchor': 'middle', 'font-size': 12});
        return text;
    }

    protected getWidth(): number {
        return WfDefines.G_RECT_H;
    }

    protected getHeight(): number {
        return WfDefines.G_RECT_H;
    }

}