import IGElement from "../../../../../common/ui/graphic/IGElement";
import WfConstants from "../../../base/WfConstants";
import WfDefines from "../../../base/WfDefines";
import AbstractWfElement from "../AbstractWfElement";
import AbstractLink from "./AbstractLink";

export default class DenyFlow extends AbstractLink {

    constructor() {
        super();
    }

    public getType(): string {
        return WfConstants.NODE_Flow_Deny;
    }

    protected getDefaultCaption(): string {
        return WfConstants.C_Flow_Deny;
    }

    public newInstance(): AbstractWfElement {
        return new DenyFlow();
    }

    public drawGraphic(): IGElement {
        this.group = {
            line: this.gSection.path(""),
            hide: this.gSection.path(""),
            triangle: this.gSection.path(""),
            fromHandler: this.gSection.circle(0, 0, 0), 
            toHandler: this.gSection.circle(0, 0, 0),
            optSymbo: this.gSection.section()
        };
        this.group.line.attr({stroke: this.getNormalStrokeColor(), 'fill-opacity': '0.5', 'stroke-dasharray': '5,5'});
        super.setVisiable(false);
        return this.group.line;
    }

    public drawLink(): void {
        if (this.fromNode && this.toNode) {
            var pos = this.getPos(this.fromNode.getBounds(), this.toNode.getBounds());
            this.group.line.attr({"path": pos.linestr}).attr({stroke: this.getNormalStrokeColor()});
            this.group.triangle.attr({"path": pos.trianglestr});
        }
    }

    protected getNormalStrokeColor(): string {
        return WfDefines.G_COLOR_STROKE_DENY;
    }
}