import ISelectable from "../../../common/selection/ISelectable";
import GlobalConstants from "../../../common/struct/GlobalConstants";
import IXmlEntity from "../../../common/xml/IXmlEntity";
import ITagNode from "../../../common/xml/node/ITagNode";
import TagNode from "../../../common/xml/node/TagNode";
import I18N from "../base/I18N";
import WfConstants from "../base/WfConstants";
import WfDefines from "../base/WfDefines";

export default class WfNodeUtil {

    /**
     * 判断节点是否可以删除，开始和结束节点必须保留各一个
     * @param xmlEntity 
     * @param tagNode 
     * @returns 
     */
    static canRemove(xmlEntity: IXmlEntity, tagNode: ITagNode): boolean {
        var tagName = tagNode.getTagName();
        if ( tagName == WfConstants.NODE_Event_Begin 
            || tagName == WfConstants.NODE_Event_End) {
            var beginCount = 0, endCount = 0;
            var children = xmlEntity.getTagRoot().getChildren();
            for (let child of children) {
                var node = <ITagNode> child;
                if (node.getTagName() == WfConstants.NODE_Event_Begin) beginCount++;
                if (node.getTagName() == WfConstants.NODE_Event_End) endCount++;
            }
            if (tagName == WfConstants.NODE_Event_Begin) return beginCount > 1;
            if (tagName == WfConstants.NODE_Event_End) return endCount > 1;
        }
        return true;
    }

    static createNode(xmlEntity: IXmlEntity, id: string, type: string, x: number, y: number): ITagNode {
        var tagNode = xmlEntity.getNodeFactory().createTagNode(type);
        tagNode.setAttributeValue(GlobalConstants.S_ID, id);
        tagNode.setAttributeValue(GlobalConstants.S_Key, type + GlobalConstants.SP_KEY + String(id));
        tagNode.setAttributeValue(GlobalConstants.S_Caption, I18N.getString(type));
        var xmlGraphicNode = xmlEntity.ensureNode(WfConstants.NODE_NodeGraphic, tagNode); 
        xmlGraphicNode.setAttributeValue(WfConstants.ATTR_X, String(x));
        xmlGraphicNode.setAttributeValue(WfConstants.ATTR_Y, String(y));
        return tagNode;
    }

    static ensurePermNode(xmlEntity: IXmlEntity, curNode: ISelectable | undefined): ITagNode {
        var tagNode = (curNode instanceof TagNode) ? <TagNode> curNode : xmlEntity.getTagRoot();
        var isRoot = (tagNode == xmlEntity.getTagRoot());
        var permNode;
        if (isRoot) {
            var permCollection = tagNode.ensureChild(WfConstants.NODE_PermCollection);
            permNode = permCollection.ensureChild(WfConstants.NODE_Perm);
        } else {
            permNode = tagNode.ensureChild(WfConstants.NODE_Perm);
        }
        return permNode;
    }

    static ensureDMTableNode(xmlEntity: IXmlEntity): ITagNode {
        var tagNode = xmlEntity.getTagRoot();
        return tagNode.ensureChild(WfConstants.NODE_DMTable);
    }

    /**
     * 根据新增节点类型计算出新增节点最左端x坐标及最上端y坐标
     * @param type 节点类型
     * @param x 节点中心x坐标
     * @param y 节点中心y坐标
     * @returns 
     */
    static cacleNodeLoc(type:string,x:number,y:number){
        if(type == WfConstants.NODE_Event_State ){
            x = x - WfDefines.G_CIRCLE_R;
            y = y - WfDefines.G_CIRCLE_R;
        }
        if(type == WfConstants.NODE_Task_Audit || type == WfConstants.NODE_Task_CounterSign || type == WfConstants.NODE_Task_DataMap || type == WfConstants.NODE_Task_Manual
            || type == WfConstants.NODE_Task_MultiAudit || type == WfConstants.NODE_Task_MultiUser || type == WfConstants.NODE_Task_Service || type == WfConstants.NODE_Task_StateAction
            || type == WfConstants.NODE_Task_User)
        {
            x = x - WfDefines.G_RECT_W / 2;
            y = y - WfDefines.G_RECT_H / 2;
        }
        if(type == WfConstants.NODE_Gateway_ComplexJoin || type == WfConstants.NODE_Gateway_Decision || type == WfConstants.NODE_Gateway_ExclusiveFork || type == WfConstants.NODE_Gateway_Fork
            || type == WfConstants.NODE_Gateway || type == WfConstants.NODE_Gateway_Join)
        {
            x = x - WfDefines.G_RECT_H / 2;
            y = y - WfDefines.G_RECT_H / 2;
        }
        return {leftx:x,topy:y};
    }
}