import ActionNames from "../../../common/event/ActionNames";
import WfConstants from "../base/WfConstants";

export default class WfActionUtil {

    public static ACTION_ON_LINE: string[] = [
        WfConstants.NODE_Event_State,
        WfConstants.NODE_Task_Audit,
        WfConstants.NODE_Task_Service,
        WfConstants.NODE_Task_CounterSign,
        WfConstants.NODE_Gateway_Decision,
        ActionNames.model_node_remove
    ];

    public static ACTION_ON_NODE: string[] = [
        WfConstants.NODE_Event_State,
        WfConstants.NODE_Task_Audit,
        WfConstants.NODE_Task_Service,
        WfConstants.NODE_Task_CounterSign,
        WfConstants.NODE_Gateway_Decision,
        WfConstants.NODE_Flow_Sequence,
        ActionNames.model_node_remove
    ];

    /** 定义节点上的不用操作 */
    private static mapUnableAction: Map<string, any> = new Map([
        [WfConstants.NODE_Event_Begin, [ActionNames.model_node_remove]],
        [WfConstants.NODE_Event_End, [WfConstants.NODE_Flow_Sequence, ActionNames.model_node_remove]]
    ]);


    static isUnableAction(nodeType: string, action: string): boolean {
        if (!WfActionUtil.mapUnableAction.has(nodeType)) {
            return false;
        }
        var unableActions = WfActionUtil.mapUnableAction.get(nodeType);
        return unableActions.indexOf(action) !== -1;
    }
}