import IGElement from "../../../common/ui/graphic/IGElement";
import WfGraphicView from "../view/WfGraphicView";
import ViewElementFactory from "../view/ViewElementFactory";
import AbstractWfOptState from "./AbstractWfOptState";
import OptStateDelegate from "./OptStateDelegate";

export default class NewNodeState extends AbstractWfOptState {

    private shadow!: IGElement | undefined;

    constructor(view: WfGraphicView, delegate: OptStateDelegate) {
        super(view, delegate);
    }

    dragstart(x: number, y: number, event: MouseEvent): void {
        this.shadow = this.ensureShadow();
    }

    dragmove(dx: number, dy: number, x: number, y: number, event: MouseEvent): void {
        this.shadow = this.ensureShadow();
        this.shadow && this.shadow.attr({transform: 'T' + [x, y]});
    }

    dragend(event: MouseEvent): void {
        this.shadow && this.shadow.remove();
        this.getDelegate().reset();
    }

    mousedown(e: MouseEvent): void {
    }

    private shadowX = 0;
    private shadowY = 0;

    mousemove(e: MouseEvent): void {
        this.shadow = this.ensureShadow();
        if (this.shadow) {
            var dx = this.shadow.getBBox().width / 2;
            var dy = this.shadow.getBBox().height / 2;
            this.shadowX = e.offsetX - dx;
            this.shadowY = e.offsetY - dy;
            this.shadow.attr({transform: 'T' + [this.shadowX, this.shadowY]});
        }
    }
    
    mouseup(e: MouseEvent): void { 
        var dx = 0, dy = 0;
        if (this.shadow) {
            dx = this.shadow.getBBox().width / 2;
            dy = this.shadow.getBBox().height / 2;
            this.shadow.remove();
            this.shadow = undefined;
        }
        this.view.doNewNodeCmd(this.getType(), this.shadowX, this.shadowY);
        this.getDelegate().reset();
        this.shadowX = 0;
        this.shadowY = 0;
    }

    private ensureShadow(): IGElement | undefined {
        if (this.shadow) return this.shadow;
        this.shadow = ViewElementFactory.createShadowGraphic(this.getType(), this.view.getPaper());
        return this.shadow;
    }
}