import ITagNode from "../../../common/xml/node/ITagNode";
import AbstractNode from "../view/element/node/AbstractNode";
import WfGraphicView from "../view/WfGraphicView";
import AbstractWfOptState from "./AbstractWfOptState";
import OptStateDelegate from "./OptStateDelegate";

export default class NewLinkState extends AbstractWfOptState {

    private fromTag?: ITagNode;

    private toNodeKey?: string;

    constructor(view: WfGraphicView, delegate: OptStateDelegate) {
        super(view, delegate);
    }

    dragstart(x: number, y: number, event: MouseEvent): void {
    }

    dragmove(dx: number, dy: number, x: number, y: number, event: MouseEvent): void {
    }

    dragend(event: MouseEvent): void {
    }

    mousedown(e: MouseEvent): void {
        var node = this.view.hitNode(e.offsetX, e.offsetY);  //this.view.hitHtmlElement(<HTMLElement> e.target);
        this.view.getSelectionModel().select(node?.getTagNode());
        if (!this.fromTag && node instanceof AbstractNode) {
            this.setFromNode(node);
            return;
        }

        var toTag;
        if (!this.toNodeKey && node instanceof AbstractNode) {
            toTag = node.getTagNode();
            this.toNodeKey = node.getKey();
        }

        if (this.fromTag && this.toNodeKey && this.fromTag != toTag) {
            this.view.doNewLinkCmd(this.getType(), this.fromTag, this.toNodeKey);
            this.reset();
        }
        if (e.button ==2 ) { 
            this.reset();
        } 
    }

    setFromNode(fromNode: AbstractNode) {
        this.fromTag = fromNode.getTagNode();
        this.ensureShadowLink().setFromNode(fromNode);
    }

    mousemove(e: MouseEvent): void {
        if (this.fromTag) {
            this.ensureShadowLink().drawShadowToLink({x: e.offsetX, y: e.offsetY, width: 4, height: 4});
        } 
    }

    mouseup(e: MouseEvent): void { 
    }

    reset(): void {
        super.reset();
        this.fromTag = undefined;
        this.toNodeKey = undefined;
        //this.getDelegate().reset();
    }
}