import IGElement from "../../../common/ui/graphic/IGElement";
import ITagNode from "../../../common/xml/node/ITagNode";
import AbstractNode from "../view/element/node/AbstractNode";
import ViewElementFactory from "../view/ViewElementFactory";
import WfGraphicView from "../view/WfGraphicView";
import AbstractWfOptState from "./AbstractWfOptState";
import OptStateDelegate from "./OptStateDelegate";

export default class NewLinkAndNodeState extends AbstractWfOptState {

    private fromTag?: ITagNode;

    private shadow!: IGElement | undefined;

    private linkType: string = "";

    private nodeType: string = "";

    constructor(view: WfGraphicView, delegate: OptStateDelegate) {
        super(view, delegate);
    }

    dragstart(x: number, y: number, event: MouseEvent): void {
    }

    dragmove(dx: number, dy: number, x: number, y: number, event: MouseEvent): void {
    }

    dragend(event: MouseEvent): void {
    }

    mousedown(e: MouseEvent): void {
        var dx = 0, dy = 0;
        if (this.shadow) {
            dx = this.shadow.getBBox().width / 2;
            dy = this.shadow.getBBox().height / 2;
            this.shadow.remove();
            this.shadow = undefined;
        }
        this.view.doNewNodeCmd(this.nodeType, this.shadowX, this.shadowY);
        var node = this.view.hitNode(this.shadowX, this.shadowY);
        this.view.doNewLinkCmd(this.linkType, this.fromTag, node?.getKey());
        this.getDelegate().reset();
        this.shadowX = 0;
        this.shadowY = 0;
    }

    setToNodeType(nodeType: string): void {
        this.nodeType = nodeType;
        this.setType(nodeType);
    }

    setLinkType(linkType: string): void {
        this.linkType = linkType;
    }
    
    setFromNode(fromNode: AbstractNode) {
        this.fromTag = fromNode.getTagNode();
        this.ensureShadowLink().setFromNode(fromNode);
    }

    private shadowX = 0;
    private shadowY = 0;

    mousemove(e: MouseEvent): void {
        this.shadow = this.ensureShadow();
        if (this.shadow) {
            var dx = this.shadow.getBBox().width / 2;
            var dy = this.shadow.getBBox().height / 2;
            this.shadowX = e.offsetX - dx;
            this.shadowY = e.offsetY - dy;
            this.shadow.attr({transform: 'T' + [this.shadowX, this.shadowY]});
        }
        if (this.fromTag) {
            this.ensureShadowLink().drawShadowToLink({x: e.offsetX, y: e.offsetY, width: 4, height: 4});
        } 
    }
    
    mouseup(e: MouseEvent): void { 
    }

    private ensureShadow(): IGElement | undefined {
        if (this.shadow) return this.shadow;
        this.shadow = ViewElementFactory.createShadowGraphic(this.nodeType, this.view.getPaper());
        return this.shadow;
    }
}