import AbstractLink from "../view/element/link/AbstractLink";
import WfGraphicView from "../view/WfGraphicView";
import AbstractWfOptState from "./AbstractWfOptState";
import OptStateDelegate from "./OptStateDelegate";

export default class ChangeLineFormNodeState extends AbstractWfOptState {

    private link?: AbstractLink;

    constructor(view: WfGraphicView, delegate: OptStateDelegate) {
        super(view, delegate);
    }

    setLink(link: AbstractLink): void {
        this.link = link;
        this.ensureShadowLink().setToNode(link.getToNode());
    }

    dragstart(x: number, y: number, event: MouseEvent): void {

    }

    dragmove(dx: number, dy: number, x: number, y: number, e: MouseEvent): void {
        this.ensureShadowLink().drawShadowFromLink({x: e.offsetX, y: e.offsetY, width: 4, height: 4});
    }

    dragend(event: MouseEvent): void {
        var node = this.view.hitNode(event.offsetX, event.offsetY);
        if (this.link && node && node != this.link?.getFromNode()) {
            var orgFromTag = this.link.getFromNode()?.getTagNode();
            var fromTag = node.getTagNode();
            orgFromTag && this.view.doChangeLineFromNodeCmd(fromTag, orgFromTag, this.link.getTagNode());
        }
        this.reset();
    }

    mousedown(e: MouseEvent): void {
    }

    mousemove(e: MouseEvent): void { 
    }

    mouseup(e: MouseEvent): void { 
    }

    reset() {
        super.reset();
        this.link = undefined;
        // this.getDelegate().reset();
    }
}