import ICmd from "../../../common/cmd/ICmd";
import ITagNode from "../../../common/xml/node/ITagNode";
import I18N from "../base/I18N";
import WfNodeUtil from "../util/WfNodeUtil";
import AbstractNode from "../view/element/node/AbstractNode";
import WfGraphicView from "../view/WfGraphicView";

export default class DeleteElementCmd implements ICmd {

    private tagNodes: ITagNode[];

    private links: ITagNode[] = [];

    private view: WfGraphicView;

    constructor(view: WfGraphicView, tagNodes: ITagNode[]) {
        this.view = view;
        this.tagNodes = tagNodes;
    }

    do(): boolean {
        var xmlEntity = this.view.getXmlEntity();
        for (let tagNode of this.tagNodes) {
            //if (WfActionUtil.isUnableAction(tagNode.getTagName(), ActionNames.model_node_remove)) {
            if (xmlEntity && !WfNodeUtil.canRemove(xmlEntity, tagNode)) {
                throw new Error(`${I18N.getString(tagNode.getTagName())}节点不能删除，必须保留至少一个!`);
            }
            var viewNode = this.view.findElement(tagNode)
            if (viewNode instanceof AbstractNode) {
                for (let link of this.view.getRelationLinks(<AbstractNode> viewNode)) {
                    if (this.links.indexOf(link.getTagNode()) == -1) {
                        this.links.push(link.getTagNode());
                    }
                }
            }
        }
        for (let node of this.tagNodes) {
            xmlEntity?.removeNode(node);
        }

        for (let link of this.links) {
            xmlEntity?.removeNode(link);
        }
        return true;
    }

    undo(): void {
        var xmlEntity = this.view.getXmlEntity();
        for (let node of this.tagNodes) {
            xmlEntity?.addNode(node, node.getParent());
        }

        for (let link of this.links) {
            xmlEntity?.addNode(link, link.getParent());
        }
    }

}