import ICmd from "../../../common/cmd/ICmd";
import ITagNode from "../../../common/xml/node/ITagNode";
import WfConstants from "../base/WfConstants";
import AbstractLink from "../view/element/link/AbstractLink";
import WfGraphicView from "../view/WfGraphicView";
import ChangeLineToNodeCmd from "./ChangeLineToNodeCmd";
import NewLinkCmd from "./NewLinkCmd";
import NewNodeCmd from "./NewNodeCmd";
import WfNodeUtil from "../util/WfNodeUtil";


export default class AddNodeOnLineCmd implements ICmd {

    private type: string;

    private id: number;

    private link: AbstractLink;

    private tagNode?: ITagNode;

    private view: WfGraphicView;

    private cmds: ICmd[] = [];

    constructor(view: WfGraphicView, id: number, type: string, link: AbstractLink) {
        this.view = view;
        this.id = id;
        this.type = type;
        this.link = link;
    }

    do(): boolean {
        var xmlEntity = this.view.getXmlEntity();
        if (!xmlEntity || !this.link) return false;
        var gl =  this.link.getOptSymbo();
        var x = WfNodeUtil.cacleNodeLoc(this.type, gl.getBBox().cx, gl.getBBox().cy).leftx;
        var y = WfNodeUtil.cacleNodeLoc(this.type, gl.getBBox().cx, gl.getBBox().cy).topy;
        //this.tagNode = WfNodeUtil.createNode(xmlEntity, this.id, this.type, x, y);
        //xmlEntity.addNode(this.tagNode);

        var cmd0 = new NewNodeCmd(xmlEntity, this.id, this.type, x, y);
        cmd0.do();
        this.cmds.push(cmd0);

        var toNode = this.view.getViewNode(String(this.id));
        var orgToKey = this.link.getToKey();
        if (toNode) {
            var tagLink = this.link.getTagNode();
            var cmd1 = new ChangeLineToNodeCmd(xmlEntity, tagLink, toNode.getKey());
            cmd1.do();
            this.cmds.push(cmd1);

            var linkID = this.view.newID()
            var cmd2 = new NewLinkCmd(xmlEntity, linkID, WfConstants.NODE_Flow_Sequence, toNode.getTagNode(), orgToKey);
            cmd2.do();
            this.cmds.push(cmd2);
        } else {
            return false;
        }
        return true;
    }

    undo(): void {
        var xmlEntity = this.view.getXmlEntity();
        if (!xmlEntity) return;
        for (var i = this.cmds.length - 1; i >=0; i--) {
            this.cmds[i].undo();
        }
        //this.tagNode && xmlEntity.removeNode(this.tagNode);
    }

}