import WfConstants from "./WfConstants";

export default class Unicode {

    private static map: Map<string, string> = new Map([
        [WfConstants.NODE_Task_Audit, WfConstants.U_Task_Audit],
        [WfConstants.NODE_Task_Service, WfConstants.U_Task_Service],
        [WfConstants.NODE_Task_Manual, WfConstants.U_Task_Manual],
        [WfConstants.NODE_Task_User, WfConstants.U_Task_User],
        [WfConstants.NODE_Task_DataMap, WfConstants.U_Task_DataMap],
        [WfConstants.NODE_Task_CounterSign, WfConstants.U_Task_CounterSign],
        [WfConstants.NODE_Task_MultiUser, WfConstants.U_Task_MultiUser],
        [WfConstants.NODE_Task_MultiAudit, WfConstants.U_Task_MultiAudit],
        [WfConstants.NODE_Task_StateAction, WfConstants.U_Task_StateAction],
        
        [WfConstants.NODE_SubProcess, WfConstants.U_SubProcess],
        [WfConstants.NODE_Inline, WfConstants.U_Inline]
    ]);

    public static get(key: string): string {
        var code = Unicode.map.get(key)
        return code ? code : key;
    }
}
