import ISelectable from "../../selection/ISelectable";
import IAttribute from "../attribute/IAttribute";
import INodeOutput from "../output/INodeOutput";
import INode from "./INode";

export default interface ITagNode extends INode, ISelectable {

	getTagName(): string;

	find(tag: string, primaryKey: string, primaryValue: string): ITagNode | undefined;

	addChild(child: INode): INode;

	removeChild(child: INode): void;

	addAttribute(key: string, value: string): IAttribute;

	getChildren(): INode[];

	clearChildren( tag?: string, onlyClearUserDefine?: boolean, attrKey?: string, attrValue?: string): void;

	getChild(tag: string): ITagNode | null;

	ensureChild(tag: string): ITagNode;

	getAttributes(): IAttribute[];

	setAttributeValue(key: string, value: string, defaultValue?: string): void;

	removeAttribute(key: string): void;

	getAttributeValue(key: string, defaultValue?: string): string;

	getAttributeValueInt(key:string, defaultValue: number): number;

	getAttributeValueBoolean(key:string, defaultValue: boolean): boolean;

	hasAttribute(key: string): boolean;

	setCDATAValue(cdata: string): void;

	getCDATAValue(): string;

	getCDATA(): string;
	
	toXml(bSimple: boolean): string;

	hasChild(): boolean;

	output(outputHandler: INodeOutput): void;
}
