import CmdQueue from "../cmd/CmdQueue";
import IEventListener from "../listener/IEventListener";
import ISelectable from "../selection/ISelectable";
import SelectionModel from "../selection/SelectionModel";
import { ITagNodeContainer } from "../view/ITagNodeContainer";
import INode from "./node/INode";
import INodeFactory from "./node/INodeFactory";
import ITagNode from "./node/ITagNode";

export default interface IXmlEntity extends ITagNodeContainer {

	getRoot(): ITagNode;

	getTagRoot(): ITagNode;

	addNode(node: ITagNode, parentNode?: ITagNode): ITagNode;

	ensureNode(tagName: string, parent: ITagNode): ITagNode;

	removeNode(node: ITagNode): void;

	removeSelectNode(): void;

	find(tag: string, primaryKey: string, primaryValue: string): ITagNode | undefined;

	getNodeFactory(): INodeFactory;
	
	getXml(bSimple: boolean): string;

	getSelectionModel(): SelectionModel;

	addEventListener(listener: IEventListener) : void;

	select(selectable: ISelectable | undefined | null): void;

	unselect(selectable: ISelectable): void;

	unSelectAll(): void;

	getCmdQueue(): CmdQueue;

	reload(xml: string): void;

	undo(): void;

	redo(): void;

	findNodeByLine(line: number): INode | null;

	genNextNodeID(): number;

	fireCommit(): void;

}
