
export default class StringBuilder {

    private arrStr: string[] = [];

    constructor() {
    }

    public append(char: string): StringBuilder {
        this.arrStr.push(char);
        return this;
    }

    public appends(chars: string[]): StringBuilder {
        for (let char of chars) {
            this.append(char);
        }
        return this;
    }

    /**
     * 移除数组中某个位置的元素
     * @param index 
     * @returns 
     */
    public deleteCharAt(index: number): StringBuilder {
        this.arrStr.splice(index, 1);
        return this;
    }

    /**
     * 移除单个末尾元素，这里移除的元素并非单个字符，而是单个 append 方法添加进来的字符串
     */
    public deleteLastChar(): StringBuilder {
        this.arrStr.pop();
        return this;
    }

    /**
     * 移除多个末尾元素，这里移除的元素并非单个字符，而是单个 append 方法添加进来的字符串
     */
    public deleteLastChars(len: number): StringBuilder {
        for (var n=0; n<len; n++) {
            this.arrStr.pop();
        }
        return this;
    }

    public rollbackTo(index: number): StringBuilder {
        var curLastIndex = this.getLastIndex();
        if (curLastIndex <= index) return this;
        var len = curLastIndex - index;
        return this.deleteLastChars(len);
    }

    public getLastIndex(): number {
        return this.getSize() - 1;
    }

    public getSize(): number {
        return this.arrStr.length;
    }

    public isEmpty(): boolean {
        return this.arrStr.length == 0;
    }

    public toString(): string {
        return this.arrStr.join("");
    }

    public toStringWithSep(sep: string): string {
        return this.arrStr.join(sep);
    }
}