import AbstractOptState from "./AbstractOptState";

export default abstract class AbstractOptStateDelegate<V> {

    private view: V;

    private initState!: AbstractOptState<V, AbstractOptStateDelegate<V>>;

    private currentState!: AbstractOptState<V, AbstractOptStateDelegate<V>>;

    constructor(view: V) {
        this.view = view;
    }

    public setInitState(initState: AbstractOptState<V, AbstractOptStateDelegate<V>>): void {
        this.initState = initState;
        this.reset();
    }

    public getInitState(): AbstractOptState<V, AbstractOptStateDelegate<V>> {
        return this.initState;
    }

    public setCurrentState(state: AbstractOptState<V, AbstractOptStateDelegate<V>>): void {
        this.currentState = state;
    }

    public getCurrentState(): AbstractOptState<V, AbstractOptStateDelegate<V>> {
        return this.currentState;
    }

    public getView(): V {
        return this.view;
    }

    public reset(): void {
        if (this.currentState == this.initState) {
            return;
        }
        var orgState = this.currentState;
        this.setCurrentState(this.initState);
        orgState && orgState.reset();
    }

}