import IXElement from "../IXElement";

export default class VNodeXElement  implements IXElement {

    private vElm: YIUI.YElement;

    constructor(data: string | HTMLElement | YIUI.YElement) {
        if (data instanceof Element) {
            this.vElm = new YIUI.YElement(YIUI.toVNode(data));
            this.vElm.getYelementData().setRawDomElm(data);
            // this.vElm.$setRawDomElm(data); bb98af6 huangxc
        } else if (data instanceof YIUI.YElement) {
            this.vElm = data;
        } else {
            var htmlElement = document.createElement(data);
            this.vElm = new YIUI.YElement(YIUI.toVNode(htmlElement));
            this.vElm.getYelementData().setRawDomElm(htmlElement);
            // this.vElm.$setRawDomElm(htmlElement); bb98af6 huangxc
        }
    }

    parentEl(): IXElement | null {
        let parent = this.vElm.$parent()
        if (!parent) return null;
        return new VNodeXElement(parent);
    }

    focus(): void {
        this.vElm.$focus();
    }

    getImpl(): YIUI.YElement {
        return this.vElm;
    }

    setInnerText(text: string): void {
        this.vElm.$setInnerText(text);
    }

    getInnerText(): string {
        return this.vElm.getInnerText();
    }

    setAttribute(name: string, value: any): void {
        this.vElm.$setAttr(name, value);
    }

    getAttribute(name: string) {
        return this.vElm.getAttr(name);
    }

    removeAttribute(name: string): void {
        this.getHtmlElement().removeAttribute(name);
    }

    setStyle(key: any, value: any): void {
        this.vElm.$addStyle(key, value);
    }

    addClass(cls: string): void {
        this.vElm.$addClass(cls);
    }

    removeClass(cls: string): void {
        this.vElm.$removeClass(cls);
    }

    toggleClass(cls: string): void {
        this.vElm.$toggleClass(cls);
    }

    hasClass(cls: string): boolean {
        return this.vElm.hasClass(cls);
    }

    appendChild(child: IXElement): void {
        this.vElm.$append(child.getImpl());
    }

    appendTo(parent: IXElement): void {
        this.vElm.$appendTo(parent.getImpl())
    }

    removeChild(child: IXElement): void {
        child.getImpl().$remove();
    }

    addEventListener(name: string, fun: any, useCapture: boolean): void {
        this.vElm.$addListener(name, fun);
    }

    removeEventListener(name: string, fun: any, useCapture: boolean): void {
        this.vElm.$removeListener(name, fun);
    }

    blur(): void {
        this.vElm.$blur();
    }

    getHtmlElement(): HTMLElement {
        return this.vElm.getElm();
    }

    getScrollTop(): number {
        return this.getHtmlElement().scrollTop;
    }

    setScrollTop(top: number): void {
        this.getHtmlElement().scrollTop = top;
    }

    getScrollLeft(): number {
        return this.getHtmlElement().scrollLeft;
    }

    setScrollLeft(left: number): void {
        this.getHtmlElement().scrollLeft = left;
    }

    getNodeType(): number {
        return this.getHtmlElement().nodeType;
    }

    getOffsetLeft(): number {
        return this.getHtmlElement().offsetLeft;
    }
    
    getOffsetTop(): number {
        return this.getHtmlElement().offsetTop;
    }

    getHtmlOffsetWidth(): number {
        return this.getHtmlElement().offsetWidth;
    }

    getHtmlClientHeight(): number {
        return this.getHtmlElement().clientHeight;
    }

    getHtmlClientWidth(): number {
        return this.getHtmlElement().clientWidth;
    }

    setOncontextmenu(fn: any): void {
        this.getHtmlElement().oncontextmenu = fn;
    }
    
    getBoundingClientRect(): any {
        return this.getHtmlElement().getBoundingClientRect();
    }

    click(): void {
        this.getHtmlElement().click();
    }

    contains(child: IXElement): boolean {
        return this.getHtmlElement().contains(child.getHtmlElement());
    }

    getChildren(): IXElement[] {
        var children: any[] = [];
        for(let elm of this.vElm.getChildElms()) {
            children.push(new VNodeXElement(elm))
        }
        return children;
    }
}