import UserEvent from "../../../../../common/event/UserEvent";
import AbstractTreeNode from "../node/AbstractTreeNode";
import JTree from "../JTree";
import TreeItem from "../model/TreeItemModel";
import JTreeNodeGroup from "./JTreeItemGroup";
import IModelBindable from "../../../../../common/model/IModelBindable";
import AbstractDomElement from "../../../../dom/AbstractDomElement";
import { EToggleStatus } from "../../../../enum/Enums";
import Events from "../../../../event/Events";

/**
 * 树节点项
 * 
 * @author chenbinbin
 */
export default class JTreeItem extends AbstractDomElement implements IModelBindable<TreeItem> {

    private itemModel: TreeItem;

    private tree: JTree;

    private childNodeGroup: JTreeNodeGroup | null = null;

    private treeNode: AbstractTreeNode;

    constructor(itemModel: TreeItem, tree: JTree) {
        super();
        this.itemModel = itemModel;
        this.setModel(itemModel);
        this.tree = tree;
        this.addClass(tree.getTreeSkin().tree_item);

        this.treeNode = tree.createNodeView(itemModel);
        this.addChild(this.treeNode);
    }

    setModel(model: TreeItem): void {
        model.bind(this);
        this.itemModel = model;
    }

    protected createEl(tag:string): HTMLElement {
        return document.createElement("li");
    }

    public toggle(): void {
        if (this.itemModel.isLeaf()) return;
        this.isCollapase() ? this.expand() : this.collapase();
    }

    public expand(): void {
        this.getModel().setToggleStatus(EToggleStatus.Expand);
    }

    public collapase(): void {
        this.getModel().setToggleStatus(EToggleStatus.Collapase);
    }

    public isCollapase(): boolean {
        return this.itemModel.isCollapase();
    }

    public isLeaf(): boolean {
       return this.itemModel.isLeaf()
    }

    public getModel(): TreeItem {
        return this.itemModel;
    }

    fireEvent(event: UserEvent): void {
        switch (event.getKey()) {
        case Events.Tree.EXPAND:
            var nodeGroup: JTreeNodeGroup = this.ensureNodeGroup();
            nodeGroup.loadChildren();
            this.treeNode.markExpand();
            break;
        case Events.Tree.COLLAPASE:
            var nodeGroup: JTreeNodeGroup = this.ensureNodeGroup();
            nodeGroup.unloadChildren();
            this.treeNode.markCollapse();
            break;   
        case Events.COMMON_SELECT_CHANGE:
            this.treeNode.markSelect(this.getModel().isSelected());
            break;
        }
    }

    public ensureNodeGroup(): JTreeNodeGroup {
        if (this.childNodeGroup == null) {
            this.childNodeGroup = new JTreeNodeGroup(this.getModel(), this.tree);
            this.addChild(this.childNodeGroup);
        }
        return this.childNodeGroup;
    }
}
