import AbstractDomElement from "../../../../dom/AbstractDomElement";
import IStyleFactory from "../../../../style/IStyleFactory";
import StyleFactoryMananger from "../../../../style/StyleFactoryMananger";

export default class JTableHeadCell extends AbstractDomElement {

    protected styleFactory: IStyleFactory =  StyleFactoryMananger.getInstance().getStyleFactory();
    
    constructor(caption: string) {
        super();
        this.setText(caption);
        this.initSkin();
    }

    private initSkin() {
        var skin = this.styleFactory.getTableSkin();
        this.addClass(skin.table_cell);
    }

    protected createEl(tag:string): HTMLElement {
        return document.createElement('th');
    }
}