import AbstractDomElement from "../../../dom/AbstractDomElement";
import JTableBodyCell from "../base/body/JTableBodyCell";
import JTableBodyRow from "../base/body/JTableBodyRow";
import ColumnAreaConfig from "../base/column/ColumnAreaConfig";
import ColumnConfig from "../base/column/ColumnConfig";
import JTable from "../base/JTable";

export default class JTableBodyArea extends AbstractDomElement {

    private bodyTable: JTable;

    private columnAreaConfig: ColumnAreaConfig;

    constructor(columnAreaConfig: ColumnAreaConfig) {
        super();
        this.columnAreaConfig = columnAreaConfig;
        this.bodyTable = new JTable("");
        //this.initColGroup();
        this.addChild(this.bodyTable.getDomElement());
        this.initSkin();
    }
/*
    private initColGroup() {
        var columns = this.columnAreaConfig.getColumns();
        for (let column of columns) {
            this.bodyTable.addCol(column.getWidth())
        }
    }*/

    private initSkin() {
        var skin = this.styleFactory.getTableSkin();
        this.addClass(skin.table_body);
        this.setStyle("overflow", "auto");
    }

    addColumn(columnConfig: ColumnConfig): void {
        this.bodyTable.addCol(columnConfig.getWidth());
    }

    addRow(): JTableBodyRow {
        var row = this.bodyTable.addBodyRow();
        var columns = this.columnAreaConfig.getColumns();
        for (let column of columns) {
            var cell = new JTableBodyCell();
            //cell.setElementWidth(SizeInfo.valueOf(column.getWidth(), ESizeType.px));
            row.addCell(cell);
        }
        return row;
    }

    setBodyCellValue(row: number, col: number, value: any): void {
        this.bodyTable.setBodyCellValue(row, col, value);
    }

    hasVScroll() {
        return (this.getHtmlOffsetWidth() - this.getHtmlClientWidth()) > 0;
    }

}