import AbstractDomElement from "../../dom/AbstractDomElement";
import EventHub from "../../event/EventHub";
import Events from "../../event/Events";
import IView from "../../interfaces/IView";
import { TabPaneSkin } from "../../style/Skins";
import StyleFactoryMananger from "../../style/StyleFactoryMananger";

export default class Tab {

    private selected: boolean = false;

    private key: string;

    private caption: string;

    private nav: TabNav;

    private content: TabContent;

    constructor(key: string, caption: string, emitter: EventHub<Tab>) {
        this.key = key;
        this.caption = caption;
        this.nav = new TabNav(this, emitter);
        this.content = new TabContent(this);
    }

    getKey(): string {
        return this.key;
    }

    getCaption(): string {
        return this.caption;
    }

    getNav(): TabNav {
        return this.nav;
    }

    getContent(): TabContent {
        return this.content;
    }

    setView(view: IView) {
        this.content.setView(view);
    }

    getView(): IView {
        return this.content.getView();
    }
    
    isSelected(): boolean {
        return this.selected;
    }

    select() :void {
        this.selected = true;
        this.nav.select();
        this.content.select();
    }

    unselect(): void {
        this.selected = false;
        this.nav.unselect();
        this.content.unselect();
    }
}

class TabNav extends AbstractDomElement {
    private tab: Tab;
    //private closeIcon!: Icon;
    private skin: TabPaneSkin;

    constructor(tab: Tab, emitter: EventHub<Tab>) {
        super();
        this.tab = tab;
        this.setText(tab.getCaption());
        //this.closeIcon = new Icon('close');
        this.skin = StyleFactoryMananger.getInstance().getStyleFactory().getTabPaneSkin();
        //this.closeIcon.addClass(this.skin.tab_close);
        //this.addChild(this.closeIcon.getDomElement());

        this.addEventListener("click", function(e: any) {
            emitter.emit(Events.Tab.NAV_SELECT, tab);
        });

        /*this.closeIcon.addEventListener("click", function(e: any) {
            e.stopPropagation();
            emitter.emit(Events.Tab.NAV_CLOSE, tab);
        });*/
    }

    getTab() {return this.tab;}

    createEl() {return super.createEl('li');}

    select() {this.addClass(this.skin.tab_nav_this);}

    unselect() {this.removeClass(this.skin.tab_nav_this);}
}

class TabContent extends AbstractDomElement {
    private tab: Tab;
    private view!: IView;
    private skin:TabPaneSkin;

    constructor(tab: Tab) {
        super();
        this.tab = tab;
        this.skin = StyleFactoryMananger.getInstance().getStyleFactory().getTabPaneSkin();
        this.addClass(this.skin.tab_item);
        this.setStyle("height", 150);
    }

    getTab() { return this.tab;}

    setView(view: IView) {this.view = view;}

    getView(): IView {return this.view};

    display(): void {this.view && this.view.display(this);}

    undisplay(): void {this.view && this.view.undisplay(this);}

    select() {
        this.addClass('swing-show');
        this.display();
    }

    unselect() {
        this.removeClass('swing-show');
        this.undisplay();
    }
}
