import DivElement from "../../dom/element/DivElement";
import LiElement from "../../dom/element/LiElement";
import SpanElement from "../../dom/element/SpanElement";
import {MenuSkin} from "../../style/Skins";
import PopupPanel from "../container/panel/PopupPanel";
import JComponent from "../JComponent";

export default class Menu extends PopupPanel {
    private static TEMPLATE_MENU: string = `
            <div class="menu">
                <div class="menu_header"><h3 class="menu_title">添加节点</h3></div>
                <div class="menu_body"/>
            </div>
            `;

    private menuStyle: MenuSkin;

    //private menuTitleEl: DivElement = new DomElement(DomUtil.parseEl(`<h3/>`));

    private menuBody: DivElement;

    constructor(title: string = "") {
        super();
        this.menuStyle = this.styleFactory.getMenuStyle();
        this.addClass(this.menuStyle.menu);

        //var menuHeaderEl: DivElement = new DivElement();
        //this.addChild(menuHeaderEl);
        //menuHeaderEl.addClass(this.menuStyle.menu_header);

        //menuHeaderEl.addChild(this.menuTitleEl);
        //this.menuTitleEl.setText(title);
        //this.menuTitleEl.addClass(this.menuStyle.menu_title);
        this.setAttr("tabindex", "0");
        this.menuBody = new DivElement();
        this.menuBody.addClass(this.menuStyle.menu_body);
        this.setContent(this.menuBody);
        let menu = this;
        this.addEventListener("blur", (e: any) => {
            setTimeout(function () {
                menu.hide();
            }, 10)
        });
    }

    setTitle(title: string): void {
        //this.menuTitleEl.setText(title);
    }

    addMenuItem(key: string, caption: string): MenuItem {
        var menuItem = new MenuItem(key, caption);
        this.menuBody.addChild(menuItem.getDomElement());

        //this.menubodyEl.addChild(menuItem);
        return menuItem;
    }

    clearChildren(): void {
        this.menuBody.clearChildren();
    }


}


class MenuItem extends JComponent<LiElement> {
    private static TEMPLATE_MENU_ITEM: string = `
                <li class="menu_item">
                    <div class="menu_content"/>
                </li>`;

    private menuStyle: MenuSkin;

    private elMenuItemContent: DivElement;

    private elCaption: SpanElement;

    constructor(key: string, caption: string) {
        super(new LiElement());
        this.setKey(key);
        this.menuStyle = this.styleFactory.getMenuStyle();
        this.addClass(this.menuStyle.menu_item);
        this.elMenuItemContent = new DivElement(); //new DomElement(<HTMLElement> this.getEl().querySelector('.menu_content'));
        this.elMenuItemContent.addClass(this.menuStyle.menu_item_content);
        this.getDomElement().addChild(this.elMenuItemContent);

        this.elCaption = new SpanElement(caption);
        this.elCaption.addClass(this.menuStyle.menu_item_caption);
        this.elMenuItemContent.addChild(this.elCaption);
    }
}

/**
 `
 <div class="cmd-change-menu__overlay">
 <div class="cmd-change-menu__header"><h3 class="cmd-change-menu__title">添加节点</h3></div>
 <div class="cmd-change-menu__body">
 <ul class="cmd-change-menu__results">
 <li class="cmd-change-menu__entry" data-entry-id="append.replace-with-exclusive-gateway" draggable="true">
 <div class="cmd-change-menu__entry-content">
 <span class="cmd-change-menu__name bpmn-icon-gateway-xor" title="Exclusive Gateway">Exclusive Gateway</span>
 </div>
 </li>

 <li class="cmd-change-menu__entry" data-entry-id="append.replace-with-exclusive-gateway" draggable="true">
 <div class="cmd-change-menu__entry-content">
 <span class="cmd-change-menu__name bpmn-icon-gateway-xor" title="Exclusive Gateway">Exclusive Gateway</span>
 </div>
 </li>
 </ul>
 <ul class="cmd-change-menu__results">
 <li class="cmd-change-menu__entry" data-entry-id="append.replace-with-exclusive-gateway" draggable="true">
 <div class="cmd-change-menu__entry-content">
 <span class="cmd-change-menu__name bpmn-icon-gateway-xor" title="Exclusive Gateway">Exclusive Gateway</span>
 </div>
 </li>

 <li class="cmd-change-menu__entry" data-entry-id="append.replace-with-exclusive-gateway" draggable="true">
 <div class="cmd-change-menu__entry-content">
 <span class="cmd-change-menu__name bpmn-icon-gateway-xor" title="Exclusive Gateway">Exclusive Gateway</span>
 </div>
 </li>
 </ul>
 </div>
 </div>
 `
 */