import DivElement from "../../dom/element/DivElement";
import AbstractControl from "./AbstractControl";

export default class DivButton extends AbstractControl<DivElement> {

    private bEnable: boolean = true;

    constructor(cls: string) {
        super(new DivElement());
        this.addClass("yg_button");
        this.addClass(cls);
    }

    setOnClickListener(fun: any): void {
        this.getDomElement().addEventListener("click", fun, false);
    }

    setEnable(b: boolean): void {
        this.bEnable = b;
        b ? this.removeClass('disabled') : this.addClass('disabled');
    }

    isEnable(): boolean {
        return this.bEnable;
    }
}