import SpanElement from "../../dom/element/SpanElement";
import SizeInfo from "../../struct/SizeInfo";
import AbstractControl from "./AbstractControl";
import Button from "./Button";
import TextEditor from "./TextEditor";

export default class ButtonEditor extends AbstractControl<SpanElement> {

    private textEditor: TextEditor;

    private button: Button;

    constructor() {
        super(new SpanElement(""));
        this.textEditor = new TextEditor();
        this.textEditor.setEditable(false);
        this.button = new Button("...");
        this.button.setStyle("padding", "0px");
        this.getDomElement().addChild(this.textEditor.getDomElement());
        this.getDomElement().addChild(this.button.getDomElement());

        /*var self = this;
        this.button.addEventListener("click", function(e: any) {
            var item = self.getPropertyItem();
            if (item && item.showInputDialog) {
                var result = item.showInputDialog(self.getValue());
                if (result != undefined) {
                    self.textEditor.setValue(result);
                }
            }
        }, true);*/
    }

    setOnButtonClick(fn: Function): void {
        this.button.addEventListener("click", fn, true);
    }

    setValue(value: any): void {
        super.setValue(value);
        this.textEditor.setValue(value);
    }

    setShowText(text: string): void {
        this.textEditor.setValue(text);
    }

    getShowText(): string {
        return this.textEditor.getValue();
    }

    setText(text: string): void {
        this.textEditor.setValue(text);
    }

    setHeight(height: SizeInfo) {
        this.textEditor.setHeight(height);
        this.button.setHeight(height);
    }

    setWidth(width: SizeInfo) {
        var w = width.getValue();
        this.textEditor.setWidth(SizeInfo.valueOfPX(w - 24));
        this.button.setWidth(SizeInfo.valueOfPX(24));
    }
}