import AbstractDomElement from "../../../dom/AbstractDomElement";
import DivElement from "../../../dom/element/DivElement";
import SizeInfo from "../../../struct/SizeInfo";

import { EComponentType } from "../../EComponentType";
import JComponent from "../../JComponent";
import AbstractLayout from "./layout/AbstractLayout";
import BaseLayoutItem from "./layout/item/BaseLayoutItem";

/**
 * @author chenbb 
 * 
 * 面板
 */
export default class JPanel<T extends BaseLayoutItem, L extends AbstractLayout<T>> extends JComponent<DivElement> {
 
    // 布局
    protected baseLayout: L;

    private bMount = false;

    public constructor(layout: L) {
        super(new DivElement());
        this.baseLayout = layout;
    }

    getTypeName(): string {
        return EComponentType.Panel;
    }

    public setLayout(layout: L): void {
        this.baseLayout = layout;
    }

    public getLayout(): L {
        return this.baseLayout;
    }
    public addComponent(component: JComponent<any>): T {
        if (this.baseLayout) {
            var layoutItem: T = this.baseLayout.addLayoutItem(component);
            return layoutItem;
        }
        throw new Error("need define layout");
    }

    public removeComponent(component: JComponent<any>): void {
        if (this.baseLayout) {
            this.baseLayout.removeLayoutItem(component);
            return;
        }
        throw new Error("need define layout");
    }

    public addEmptyLayoutItem(): T {
        if (this.baseLayout) {
            return this.baseLayout.addLayoutItem(null);
        }
        throw new Error("need define layout");
    }

    public removeAll(): void {
        this.unmountAll();
        this.baseLayout && this.baseLayout.removeAll();
    }

    public display() : void {
        this.unmountAll();
        this.mountChildren();
        this.layout();
    }

    undisplay(parent: AbstractDomElement): void {
        throw new Error("Method not implemented.");
    }

    reLayout(width: SizeInfo, height: SizeInfo): void {
        this.setWidth(width);
        this.setHeight(height);
        this.mountChildren();
        this.layout();
    }

    public unmountAll() {
        super.unmountAll();
        this.bMount = false;
    }

    public layout() {
        this.baseLayout && this.baseLayout.layout(this);
    }

    /**
     * 挂载子节点
     */
    private mountChildren(): void {
        if (this.baseLayout && !this.bMount) {
            for (let item of this.baseLayout.getLayoutItems()) {
                this.mountChild(item.getNode());
            }
            this.bMount = true;
        }
    }
}