import AbstractDomElement from "../dom/AbstractDomElement";
import SizeInfo from "../struct/SizeInfo";
import IStyleFactory from "../style/IStyleFactory";
import StyleFactoryMananger from "../style/StyleFactoryMananger";

export default abstract class JComponent<T extends AbstractDomElement> {

    protected styleFactory: IStyleFactory = StyleFactoryMananger.getInstance().getStyleFactory();

    private key!: string;

    private width: SizeInfo = SizeInfo.AUTO_SIZE;

    private height: SizeInfo = SizeInfo.AUTO_SIZE;

    private x: number = -1;
    private y: number = -1;
    private xspan: number = 1;
    private yspan: number = 1;

    private domElement: T;

    constructor(domElement: T) {
        this.domElement = domElement;
    }

    setKey(key: string) {
        this.key = key;
    }

    getKey() {
        return this.key;
    }

    setTitle(title: string): void {
        this.getEl().setAttribute("title", title);
    }

    setWidth(width: SizeInfo) {
        this.width = width;
        this.getDomElement().setStyleWidth(width);
    }

    getWidth(): SizeInfo {
        return this.width;
    }

    setHeight(height: SizeInfo) {
        this.height = height;
        this.getDomElement().setStyleHeight(height);
    }

    getHeight(): SizeInfo {
        return this.height;
    }

    getHeightValue(): number {
        return this.height ? this.height.getValue() : 0;
    }

    setText(text: string): void {
        this.getDomElement().setText(text);
    }

    getShowText(): string {
        return this.getDomElement().getText();
    }


    getX(): number {
        return this.x;
    }

    setX(x: number): void {
        this.x = x;
    }

    getXSpan(): number {
        return this.xspan;
    }

    setXSpan(xspan: number): void {
        this.xspan = xspan;
    }

    getY(): number {
        return this.y;
    }

    setY(y: number): void {
        this.y = y;
    }

    getYSpan(): number {
        return this.yspan;
    }

    setYSpan(yspan: number): void {
        this.yspan = yspan;
    }

    setLocation(x: number, y: number, xSpan: number = 1, ySpan: number = 1) {
        this.setX(x);
        this.setY(y);
        this.setXSpan(xSpan);
        this.setYSpan(ySpan);
    }

    addClass(cls: string): void {
        this.getDomElement().addClass(cls);
    }

    addClassArray(clsArray: string[] = []) {
        this.getDomElement().addClassArray(clsArray);
    }

    removeClass(cls: string): void {
        this.getDomElement().removeClass(cls);
    }

    addEventListener(name: string, fun: any, useCapture: boolean = false): void {
        this.getDomElement().addEventListener(name, fun, useCapture);
    }

    removeEventListener(name: string, fun: any, useCapture: boolean = false): void {
        this.getDomElement().removeEventListener(name, fun, useCapture);
    }

    getDomElement(): T {
        return this.domElement;
    }

    getEl(): HTMLElement {
        return this.domElement.getEl();
    }

    /**
     * 挂载
     * @param child
     */
    public mountChild(child: JComponent<any> | null) {
        child && this.getDomElement().addChild(child.getDomElement());
    }

    public unmountChild(child: JComponent<any>) {
        child && this.getDomElement().removeChild(child.getDomElement());
    }

    setDisplay(visible: boolean): void {
        this.getDomElement().setStyle("display", visible ? "block" : "none");
    }

    public unmountAll() {
        this.getDomElement().clearChildren();
    }

    setStyle(key: any, value: any): void {
        this.domElement.setStyle(key, value);
    }

    resize(width: number, height: number) {
        this.setWidth(SizeInfo.valueOfPX(width));
        this.setHeight(SizeInfo.valueOfPX(height));
    }

    render(parentEl: HTMLElement) {
        this.domElement.render(parentEl);
    }

    display(): void {
    }

    fireResized(width: SizeInfo, height: SizeInfo) {
    }

    lostFocus() {
    }
}