import ArrayList from "../struct/ArrayList";
import ICmd from "./ICmd";

export default class CmdQueue {

    private cmds: ArrayList<ICmd> = new ArrayList<ICmd>();

    private curIndex: number = -1;

    doCmd(cmd: ICmd) {
        this.removeAfterCurrent();
        if (cmd.do()) {
            this.cmds.add(cmd);
            this.curIndex ++;
        }
    }

    private removeAfterCurrent(): void {
        for (var i=this.cmds.getSize() - 1; i> this.curIndex; i--) {
            this.cmds.removeByIndex(i);
        }
    }

    undoCmd() {
        if (this.curIndex >= 0) {
           var cmd = this.cmds.get(this.curIndex);
           cmd.undo();
           this.curIndex --;
        }
    }

    redoCmd() {
        if (this.cmds.getSize() == 0) {
            return;
        }

        if (this.curIndex < this.cmds.getSize() - 1) {
            this.curIndex ++;
            var cmd = this.cmds.get(this.curIndex);
            cmd.do();
        }
    }

    clear(): void {
        this.cmds.clearAll();
        this.curIndex = -1;
    }
}