/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.webplugin.service.start;

import com.bokesoft.erp.webplugin.service.cache.AsyncVesionCache;
import com.bokesoft.erp.webplugin.service.start.DBMetaBPMLoader;
import com.bokesoft.erp.webplugin.service.workflow.extension.MetaProcessMapCollectionEx;
import com.bokesoft.erp.webplugin.service.workflow.sync.DBWorkflowBindChangeListener;
import com.bokesoft.erp.webplugin.service.workflow.sync.DBWorkflowChangeListener;
import com.bokesoft.erp.webplugin.service.workflow.util.DBWorkflowUtil;
import com.bokesoft.yes.base.IStartListener;
import com.bokesoft.yigo.meta.bpm.total.MetaProcessMap;
import com.bokesoft.yigo.meta.bpm.total.MetaProcessMapCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBMetaService
implements IStartListener {
    private static final Logger logger = LoggerFactory.getLogger(DBMetaService.class);
    private static final String MODULE_BPMN_WORKFLOW = "BPMN.WORKFLOW";
    private static final String MODULE_BPMN_WORKFLOWBIND = "BPMN.WORKFLOWBIND";

    public void invoke(DefaultContext context) throws Throwable {
        this.resetProcessMapCollection(context);
        if (DBWorkflowUtil.checkDBWorkflowExist(context)) {
            DBMetaBPMLoader dbBPMLoader = new DBMetaBPMLoader();
            logger.info("load db bpmn start!");
            dbBPMLoader.load(context);
            logger.info("load db bpmn end!");
        }
        IMetaFactory metaFactory = context.getVE().getMetaFactory();
        MetaProcessMapCollection metaProcessMapCollection = metaFactory.getMetaBPM().getMetaProcessMapCollection();
        for (MetaProcessMap metaProcessMap : metaProcessMapCollection) {
            DBWorkflowUtil.buildBPMRelationTable(metaProcessMap.getKey(), context);
            DBWorkflowUtil.buildAutoOperation(metaProcessMap.getKey(), context);
        }
        DBMetaService.getWorkflowVesionCacheInstance().setVersionChangeListener(new DBWorkflowChangeListener());
        DBMetaService.getWorkflowBindVesionCacheInstance().setVersionChangeListener(new DBWorkflowBindChangeListener());
    }

    private void resetProcessMapCollection(DefaultContext context) throws Throwable {
        MetaProcessMapCollectionEx exProcessMapCollection = new MetaProcessMapCollectionEx();
        IMetaFactory metaFactory = context.getVE().getMetaFactory();
        for (MetaProcessMap processMap : metaFactory.getMetaBPM().getMetaProcessMapCollection()) {
            exProcessMapCollection.add(processMap);
        }
        metaFactory.getMetaBPM().setMetaMapCollection((MetaProcessMapCollection)exProcessMapCollection);
    }

    public static AsyncVesionCache getWorkflowVesionCacheInstance() {
        return AsyncVesionCache.getInstance(MODULE_BPMN_WORKFLOW);
    }

    public static AsyncVesionCache getWorkflowBindVesionCacheInstance() {
        return AsyncVesionCache.getInstance(MODULE_BPMN_WORKFLOWBIND);
    }
}

