/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/erp/common/dom/AbstractDomElement.ts":
/*!**************************************************!*\
  !*** ./src/erp/common/dom/AbstractDomElement.ts ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AbstractDomElement)
/* harmony export */ });
/**
 * @author chenbb
 *
 * 抽象封装Html Dom Element 对象
 */
class AbstractDomElement {
    constructor(el) {
        this.children = [];
        this.el = el || this.createEl();
    }
    setText(caption) {
        this.el.innerText = caption;
    }
    getText() {
        return this.el.innerText;
    }
    setHeight(height) {
        this.setStyle("height", height + "px");
    }
    setWidth(width) {
        this.setStyle("width", width + "px");
    }
    setStyle(key, value) {
        this.el.style[key] = value;
    }
    setStyles(styles) {
        for (var key in styles) {
            this.setStyle(key, styles[key]);
        }
    }
    addClass(cls) {
        if (cls) {
            this.el.classList.add(cls);
        }
    }
    removeClass(cls) {
        this.el.classList.remove(cls);
    }
    toggleClass(cls) {
        this.el.classList.toggle(cls);
    }
    createEl(tag = 'div') {
        return document.createElement(tag);
    }
    getEl() {
        return this.el;
    }
    addChild(child) {
        if (child) {
            this.children.push(child);
            this.mountChild(child);
        }
    }
    removeChild(child) {
        if (child) {
            var index = this.children.indexOf(child);
            if (index >= 0) {
                this.children.splice(index, 1);
            }
            this.unmountChild(child);
        }
    }
    getChildAt(index) {
        return this.children[index];
    }
    getChildren() {
        return this.children;
    }
    clearChildren() {
        for (let child of this.children) {
            this.unmountChild(child);
        }
        this.children = [];
    }
    mountChild(child) {
        child && this.el.appendChild(child.getEl());
    }
    unmountChild(child) {
        if (child && this.el.contains(child.getEl())) {
            this.el.removeChild(child.getEl());
        }
    }
    addEventListener(name, fun, useCapture = false) {
        this.el.addEventListener(name, fun, useCapture);
    }
    findElement(el) {
        if (!el) {
            return null;
        }
        if (this.getEl() == el) {
            return this;
        }
        if (this.getChildren() != null) {
            for (let child of this.getChildren()) {
                var find = child.findElement(el);
                if (find != null)
                    return find;
            }
        }
        return null;
    }
    resize(width, height) {
    }
    fireResized(width, height) { }
    lostFocus() { }
}


/***/ }),

/***/ "./src/erp/common/dom/element/Div.ts":
/*!*******************************************!*\
  !*** ./src/erp/common/dom/element/Div.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Div)
/* harmony export */ });
/* harmony import */ var _AbstractDomElement__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../AbstractDomElement */ "./src/erp/common/dom/AbstractDomElement.ts");

/**
 * @author chenbb
 *
 * Html Div Element 对象
 */
class Div extends _AbstractDomElement__WEBPACK_IMPORTED_MODULE_0__["default"] {
    constructor() {
        super();
    }
}


/***/ }),

/***/ "./src/erp/scrollbar/VScrollBar.ts":
/*!*****************************************!*\
  !*** ./src/erp/scrollbar/VScrollBar.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ VScrollBar)
/* harmony export */ });
/* harmony import */ var _common_dom_AbstractDomElement__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../common/dom/AbstractDomElement */ "./src/erp/common/dom/AbstractDomElement.ts");
/* harmony import */ var _common_dom_element_Div__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../common/dom/element/Div */ "./src/erp/common/dom/element/Div.ts");


/**
 * @author chenbb
 *
 * 纵向滚动条，用于动态载入html元素，向外部提供位置信息，
 * 用于显示和删除html中的可见和不可见元素
 *
 * 注:仅用于行高固定的情况
 */
class VScrollBar extends _common_dom_AbstractDomElement__WEBPACK_IMPORTED_MODULE_0__["default"] {
    constructor(rowHeight, viewAreaEl, vbarListener) {
        super();
        /** 视窗显示行数 */
        this.visibleRowCount = 0;
        /** 滚动条当前位置 */
        this.position = 0;
        /** 总行数 */
        this.totalRowCount = 0;
        this.$viewAreaEl = $(viewAreaEl);
        this.rowHeight = rowHeight;
        this.barWidth = VScrollBar.getScrollBarWidth(this.$viewAreaEl);
        this.vbarListener = vbarListener;
        this.content = new _common_dom_element_Div__WEBPACK_IMPORTED_MODULE_1__["default"]();
        this.content.setWidth(this.barWidth);
        this.addChild(this.content);
        this.setStyle('position', 'absolute');
        this.setStyle('z-index', 9999);
        this.setStyle('overflow-y', 'auto');
        this.setStyle('overflow-x', 'hidden');
        this.setStyle('background-color', '#EEE');
        this.addClass(VScrollBar.CLS_DYNAMIC_SCROLL_BAR);
        this.setWidth(this.barWidth);
        this.resetViewAreaEl();
        this.update();
        var self = this;
        this.addEventListener("scroll", function (e) {
            var startIndex = Math.ceil(self.getEl().scrollTop / rowHeight);
            self.position = startIndex;
            self.ensurePosition(self.visibleRowCount);
            self.vbarListener && self.vbarListener.scroll(self.position, self.visibleRowCount);
        });
    }
    /**
     * 重置视窗
     */
    resetViewAreaEl() {
        var self = this;
        this.oldOverflowY = this.$viewAreaEl[0].style.overflowY;
        this.$viewAreaEl[0].style.overflowY = 'hidden';
        this.$viewAreaEl.on("mousewheel DOMMouseScroll", function (event) {
            event.preventDefault();
            var orgEvent = event.originalEvent;
            var wheel = orgEvent.wheelDelta || -orgEvent.detail;
            var delta = Math.max(-1, Math.min(1, wheel));
            var visibleHeight = self.$viewAreaEl.height();
            if (delta < 0) { //向下滚动
                var total = self.totalRowCount * self.rowHeight;
                if (self.getEl().scrollTop < total - visibleHeight - self.rowHeight) {
                    self.getEl().scrollTop = self.getEl().scrollTop + self.rowHeight;
                }
                else {
                    self.getEl().scrollTop = total - visibleHeight;
                }
            }
            else { //向上滚动
                if (self.getEl().scrollTop > self.rowHeight) {
                    self.getEl().scrollTop = self.getEl().scrollTop - self.rowHeight;
                }
                else {
                    self.getEl().scrollTop = 0;
                }
            }
        });
        var $el = this.$viewAreaEl;
        $el.scroll(e => {
            this.repositionLeft();
        });
        $el.resize(e => {
            this.repositionLeft();
        });
    }
    repositionLeft() {
        var left = this.$viewAreaEl.width() - this.barWidth + this.$viewAreaEl.scrollLeft();
        this.setStyle("left", left + "px");
    }
    /**
     * 设置全部行数量
     *
     * @param totalCount
     */
    setTotalCount(totalRowCount) {
        // 多加一行的高度，防止内容被底部滚动条覆盖
        this.totalRowCount = totalRowCount + 1;
        this.content.setHeight(totalRowCount * this.rowHeight);
    }
    /**
     * 设置顶点位置
     *
     * @param top
     */
    setTopPosition(top) {
        this.position = top;
        this.getEl().scrollTop = top * this.rowHeight;
    }
    /**
     * 获取顶点位置
     *
     * @returns
     */
    getTopPosition() {
        return this.position;
    }
    /**
     * 更新滚动条
    */
    update() {
        var height = this.$viewAreaEl[0].clientHeight;
        this.setHeight(height);
        // 横向滚动出现时的处理
        var isHBarVisible = this.$viewAreaEl.height() > height;
        var opacity = isHBarVisible ? 0.5 : 1;
        this.content.setStyle('opacity', opacity);
        this.setStyle('opacity', opacity);
        var curVisibleRowCount = this.getCurVisibleRowCount(height);
        if (curVisibleRowCount != this.visibleRowCount) {
            this.visibleRowCount = curVisibleRowCount;
            this.ensurePosition(this.visibleRowCount);
            this.vbarListener && this.vbarListener.init(this.position, curVisibleRowCount);
            this.vbarListener && this.vbarListener.scroll(this.position, curVisibleRowCount);
        }
        this.setStyle("top", "0px");
        this.repositionLeft();
    }
    ensurePosition(curVisibleRowCount) {
        // 改变窗口大小时，如何position已经超出，则需要重新适配最后一行位置
        // setTotalCount中多加了最后一行空白行，这里判断时需要减掉
        if (this.position + curVisibleRowCount > this.totalRowCount - 1) {
            this.position = this.totalRowCount - curVisibleRowCount - 1;
            this.position = (this.position < 0 ? 0 : this.position);
        }
    }
    /**
     * 卸载当前滚动条
     */
    unInstall() {
        this.$viewAreaEl[0].style.overflowY = this.oldOverflowY;
    }
    /**
     * 计算并获取当前视窗的可见行数
     * @param curHeight
     * @returns
     */
    getCurVisibleRowCount(curHeight) {
        return Math.floor(curHeight / this.rowHeight);
    }
    /**
     * 计算当前滚动条的宽度
     *
     * @param viewAreaEl
     * @returns
     */
    static getScrollBarWidth($viewAreaEl) {
        var noScroll = $viewAreaEl.width();
        var viewAreaEl = $viewAreaEl[0];
        var old = viewAreaEl.style.overflowY;
        viewAreaEl.style.overflowY = 'scroll';
        var scroll = viewAreaEl.clientWidth;
        viewAreaEl.style.overflowY = old;
        var width = noScroll - scroll;
        return width > 3 ? width : 17;
    }
}
VScrollBar.CLS_DYNAMIC_SCROLL_BAR = "dynamic-scroll-bar";


/***/ }),

/***/ "./src/erp/scrollbar/VScrollBarInstaller.ts":
/*!**************************************************!*\
  !*** ./src/erp/scrollbar/VScrollBarInstaller.ts ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ VScrollBarInstaller)
/* harmony export */ });
/* harmony import */ var _VScrollBar__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./VScrollBar */ "./src/erp/scrollbar/VScrollBar.ts");

/**
 * @author chenbb
 *
 * 滚动条插件的安装程序
 */
class VScrollBarInstaller {
    /** 检查当前数据行数是否满足插件安装条件 */
    static checkRowCount(lineCount) {
        return lineCount > VScrollBarInstaller.ENABLE_SIZE;
    }
    //判断当前的浏览器环境是否支持html5
    static checkEnv() {
        return true;
    }
    /**
     * 检查视窗中是否已安装过该插件
     * @param viewAreaEl
     * @returns
     */
    static checkInstalled(viewAreaEl) {
        var elems = viewAreaEl.getElementsByClassName(_VScrollBar__WEBPACK_IMPORTED_MODULE_0__["default"].CLS_DYNAMIC_SCROLL_BAR);
        return elems && elems.length > 0;
    }
    /**
     * 安装插件
     * @param rowHeight
     * @param viewAreaEl
     * @param vbarListener
     * @returns
     */
    static install(rowHeight, viewAreaEl, vbarListener) {
        var vbar = new _VScrollBar__WEBPACK_IMPORTED_MODULE_0__["default"](rowHeight, viewAreaEl, vbarListener);
        viewAreaEl.appendChild(vbar.getEl());
        return vbar;
    }
    /**
     * 卸载插件
     * @param viewAreaEl
     * @param vbar
     */
    static uninstall(viewAreaEl, vbar) {
        if (viewAreaEl && vbar) {
            vbar.unInstall();
            viewAreaEl.removeChild(vbar.getEl());
        }
    }
}
/** 插件启用数据行数 */
VScrollBarInstaller.ENABLE_SIZE = 500;


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be isolated against other modules in the chunk.
(() => {
/*!*********************!*\
  !*** ./src/main.ts ***!
  \*********************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _erp_scrollbar_VScrollBarInstaller__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./erp/scrollbar/VScrollBarInstaller */ "./src/erp/scrollbar/VScrollBarInstaller.ts");

window.VScrollBarInstaller = _erp_scrollbar_VScrollBarInstaller__WEBPACK_IMPORTED_MODULE_0__["default"];

})();

/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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