import Collapse from "../../../../../common/component/control/Collapse";
import AbstractGridPanelCollapsibleHandler from "./AbstractGridPanelCollapsibleHandler";

export default class GridPanelCollapsibleHandlerForTable extends AbstractGridPanelCollapsibleHandler {

    constructor(gridPanel: YIUI.Panel.GridLayoutPanel) {
        super(gridPanel);
    }

    renderCollapseControl(control: Collapse): void {
        if (!this.gridPanel.getEl()) return;
        
        var row = control.getY();
        //var rowSelector = `tbody tr[row='${row}']`;
        var rowSelector = `table tr[row='${row}']`;
        var $row = $(rowSelector, this.gridPanel.getEl());
        var col = control.getX();
        var cellSelector = `td[col='${col}']`;
        var $cell = $(cellSelector, $row);
        if ($cell && $cell[0]) {
            //@ts-ignore
            control.render($cell[0]);
        }
    }

    updateRowVisible(row: number, visible: boolean): void {
        var rowSelector = `table tr[row='${row}']`;
        var $row = $(rowSelector, this.gridPanel.getEl());
        $row.css('display', visible ? '': 'none');
    }
    
    updatePanel(): void {
    }
}