import Collapse from "../../../../../common/component/control/Collapse";
import DomElement from "../../../../../common/dom/element/DomElement";
import GlobalStyle from "../../../../../common/style/GlobalStyle";
import StringBuilder from "../../../../../common/util/StringBuilder";
import StringUtil from "../../../../../common/util/StringUtil";
import AbstractGridPanelCollapsibleHandler from "./AbstractGridPanelCollapsibleHandler";

export default class GridPanelCollapsibleHandlerForH5 extends AbstractGridPanelCollapsibleHandler {

    private rowsVisible: boolean[] = [];
    private orgRowsHeight: string[] = [];

    constructor(gridPanel: YIUI.Panel.GridLayoutPanel) {
        super(gridPanel);
        var arrRowDefines = this.getRowDefines(gridPanel);
        for (var i = 0; i < arrRowDefines.length; i++) {
            this.rowsVisible[i] = true;
            this.orgRowsHeight[i] = arrRowDefines[i];
        }
    }

    renderCollapseControl(control: Collapse): void {
        if (!this.gridPanel.getEl()) return;
        var row = control.getY() + 1;
        var col = control.getX() + 1;
        var cellSelector = `div[_row='${row}'][_col='${col}']`;
        var $cell = $(cellSelector, this.gridPanel.getEl());
        if (!$cell[0]) {
            $cell = $(`<div _row="${row}" _col="${col}" class="ui-control ui-lbl ui-readonly" style="grid-row-start:${row}; grid-column-start:${col};display:grid">`);
            this.gridPanel.getEl().append($cell);
        }
        control.render(new DomElement($cell[0]).getEl());
    }
    
    updateRowVisible(row: number, visible: boolean): void {
        var cellSelector = `div[_row='${row + 1}']`;
        if (visible) {
            $(cellSelector, this.gridPanel.getEl()).removeClass(() => GlobalStyle.CLS_AREA_CELL_COLLAPSED);
        } else {
            $(cellSelector, this.gridPanel.getEl()).addClass(() => GlobalStyle.CLS_AREA_CELL_COLLAPSED);
        }
        this.rowsVisible[row] = visible;
    }

    updatePanel(): void {
        var sb = new StringBuilder();
        for (let i = 0; i < this.rowsVisible.length; i++) {
            if (this.rowsVisible[i]) {
                sb.append(this.orgRowsHeight[i]).append(" ");
            } else {
                sb.append("0px").append(" ");
            }
        }
        var sNewGridTemplateRows = sb.toString().trim();
        this.gridPanel.getEl().css('grid-template-rows', sNewGridTemplateRows);
    }

    private getRowDefines(gridPanel: YIUI.Panel.GridLayoutPanel): string[] {
        var sGridTemplateRows = gridPanel.getEl().css('grid-template-rows');
        var arrRowDefines = StringUtil.split(sGridTemplateRows, " ");
        return arrRowDefines;
    }
}