import { EComponentType } from "../../../../common/component/EComponentType";
import { XMLElementType } from "../../../../common/enum/Enums";
import IPropertyItem, { IPropertyGroup } from "../../../../design/plugin/property/base/PropertyDefine";
import YigoPropertyUIPanel from "../../../design/control/property/YigoPropertyUIPanel";
import AbstractLayoutRender from "./AbstractLayoutRender";

export default class YigoPropertyLayoutRender extends AbstractLayoutRender {

    private propertyPanel: YigoPropertyUIPanel;

    constructor(panel: YIUI.Panel) {
        super(panel);
        this.propertyPanel = new YigoPropertyUIPanel([]);
    }

    doRender(parent: any): void {
        if (!this.extraLayout) return;
        var groups = YigoPropertyLayoutRender.getPropertyGroup(this.extraLayout, this.panel);
        if (groups.length == 0) return;
        this.propertyPanel.init(groups);
        if (!parent.contains(this.propertyPanel.getEl())) {
            parent.appendChild(this.propertyPanel.getEl());
        }
        this.resize(parent.clientWidth, parent.clientHeight);
        window.addEventListener("resize", (e: any) => {
            this.resize(parent.clientWidth, parent.clientHeight);
        });
    }

    resize(width: number, height: number): void {
        this.propertyPanel.resize(width, height);
    }

    static getPropertyGroup(customLayout: YIUI.IExtraLayout, panel: YIUI.Panel): IPropertyGroup[] {
        var items = panel.items;
        if (!items || items.length ==0) return [];
        items.sort((item1, item2) => {
            return item1.y - item2.y;
        });
        var queueRecord = []; // 处理有两个控件组合的情况
        var groups = YigoPropertyLayoutRender.createGroups(customLayout);
        if (groups.length == 0) return [];
        for (let item of items) {
            if (YigoPropertyLayoutRender.isIgnoreControlType(item.type)) continue;
            if (item.visible) {
                var group = YigoPropertyLayoutRender.locGroup(item, groups);
                var propertyItem = YigoPropertyLayoutRender.createPropertyItem(group.key, item);
                var xSPAN = YigoPropertyLayoutRender.getColSpan(panel);
                if (item.colspan < xSPAN) {
                    if (queueRecord.length == 0) {
                        queueRecord.push(propertyItem);
                    } else {
                        var preItem = queueRecord.shift();
                        if (preItem) {
                            preItem.component2 = item;
                            continue;
                        }
                    }
                }
                group.properties.push(propertyItem);
            }
        }
        var result = groups.filter(group => group.properties.length > 0)
        return result; 
    }

    private static isIgnoreControlType(type: YIUI.CONTROLTYPE) {
        return type == YIUI.CONTROLTYPE.LABEL || type == YIUI.CONTROLTYPE.SEPARATOR;
    }

    private static getColSpan(panel: YIUI.Panel) {
        var colspan = 1;
        var items = panel.items;
        for (let item of items) {
            colspan = Math.max(colspan, item.colspan);
        }
        return colspan;
    }

    private static locGroup(item: YIUI.Component, groups: IPropertyGroup[]): IPropertyGroup {
        for (let group of groups) {
            var config = <YIUI.IGroupItem> group.config;
            var endRow = (config.endRow == undefined ? 9999 : config.endRow);
            if (item.y >= config.startRow && item.y <= endRow) {
                return group;
            }
        }
        return groups[0];
    }

    private static createGroups(customLayout: YIUI.IExtraLayout) {
        var groups = [];
        if (customLayout.groupCollection) {
            for (let item of customLayout.groupCollection) {
                var bExpand = (item.expanded == undefined ? true : item.expanded);
                var group = YigoPropertyLayoutRender.createPropertyGroup(item.key, item.caption, bExpand);
                group.config = item;
                groups.push(group);
            }
        }
        return groups;
    }

    private static createPropertyGroup(key: string, caption: string, bExpand: boolean): IPropertyGroup {
        return {
            key: key,
            caption: caption,
            expanded: bExpand,
            properties: []
        };
    }

    private static createPropertyItem(tag: string, component: YIUI.Component): IPropertyItem {
        return {
            tag: tag,
            key: component.key,
            caption: component.caption,
            textAttributeKey: '',
            updateAttributeOnly: true,
            control: EComponentType.YigoControl,
            type: XMLElementType.ATTRIBUTE,
            defaultvalue: '',
            editable: String(component.editable),
            visible: String(component.visible),
            component: component
        };
    }
}
/* 

                    <ExtraLayout Type="Property">
                        <GroupCollection>
                            <Group Key="G001" Caption="基础属性" Expanded="true" StartRow="1" EndRow="1"/>
                            <Group Key="G002" Caption="组件属性" Expanded="true" StartRow="3" EndRow="3"/>
                            <Group Key="G003" Caption="数据关联" Expanded="false" StartRow="5" EndRow="5"/>
                            <Group Key="G004" Caption="界面显示" Expanded="true" StartRow="7" EndRow="7"/>
                            <Group Key="G005" Caption="尺寸" Expanded="true" StartRow="9" EndRow="10"/>
                        </GroupCollection>    
                    </ExtraLayout>
*/
