import JComponent from "../../../../common/component/JComponent";
import DivElement from "../../../../common/dom/element/DivElement";
import InputElement from "../../../../common/dom/element/InputElement";
import SpanElement from "../../../../common/dom/element/SpanElement";
import SizeInfo from "../../../../common/struct/SizeInfo";
import ITagNode from "../../../../common/xml/node/ITagNode";
import AreaConstants from "../property/AreaConstants";
import SelectRange from "../selection/SelectRange";
import AreaStateDelegate from "../state/AreaStateDelegate";

/**
 * 控制点
 */
 export default class AreaHandleControl extends JComponent<DivElement> {

    private handleTagNode: ITagNode;

    private selectRange: SelectRange;

    private textSpan: SpanElement;

    private inputEl: InputElement;

    private areaStateDelegate: AreaStateDelegate;

    constructor(caption: string, handleTagNode: ITagNode, areaStateDelegate: AreaStateDelegate) {
        super(new DivElement());
        this.handleTagNode = handleTagNode;
        this.areaStateDelegate = areaStateDelegate;
        this.selectRange = new SelectRange(areaStateDelegate);
        this.getDomElement().addChild(this.selectRange);

        this.textSpan = new SpanElement(caption);
        this.getDomElement().addChild(this.textSpan);

        this.setStyle("position", "absolute");
        //this.setStyle("background-color", "#854C53");
        this.setStyle("opacity", "0.5");
        this.setStyle("border-radius", "5px");
        this.updateUI(caption);
        this.markSelected(false);
        
        this.addClass("area_handle");
        this.textSpan.addClass('area_span_text');
        this.textSpan.addClass('area_handle_text');

        this.inputEl = new InputElement();
        this.selectRange.addEventListener('dblclick', (e: MouseEvent) => {
            this.inputEl.setStyleWidth(SizeInfo.valueOfPX(this.selectRange.getHtmlClientWidth() - 30));
            this.inputEl.setStyleHeight(SizeInfo.valueOfPX(this.selectRange.getHtmlClientHeight() - 4));
            this.selectRange.setMoveEnable(false);
            this.inputEl.setValue(this.textSpan.getText());
            this.selectRange.addChild(this.inputEl);
        });
       
        this.inputEl.addEventListener('mousedown', (e: MouseEvent) =>  e.stopPropagation());
        this.inputEl.addEventListener('mouseup', (e: MouseEvent) => e.stopPropagation());
        this.inputEl.addEventListener('blur', (e: any) => this.commitCaption());
        this.inputEl.addEventListener('keyup', (e: KeyboardEvent) => {
            e.stopPropagation();
            e.key === 'Enter' && this.inputEl.blur();
        });
    }

    private commitCaption(): void {
        if (!this.selectRange.hasChild(this.inputEl)) return;
        this.areaStateDelegate.getView().doChangeAreaCaptionCmd(this.inputEl.getValue());
        this.selectRange.removeChild(this.inputEl);
        this.selectRange.setMoveEnable(true);
    }

    updateUI(caption?: string) {
        caption != undefined && this.textSpan.setText(caption);
        var tagNode = this.handleTagNode;
        this.setX(tagNode.getAttributeValueInt(AreaConstants.ATTR_X, 0));
        this.setY(tagNode.getAttributeValueInt(AreaConstants.ATTR_Y, 0));
        this.setXSpan(tagNode.getAttributeValueInt(AreaConstants.ATTR_XSpan, 1))
        this.setYSpan(tagNode.getAttributeValueInt(AreaConstants.ATTR_YSpan, 1));
        var tagFormat = tagNode.getChild(AreaConstants.NODE_Format);
        if (tagFormat) {
            var foreColor = tagFormat.getAttributeValue(AreaConstants.ATTR_ForeColor);
            this.textSpan.setStyle('color', foreColor ? foreColor : '');
            var tagFont = tagFormat.getChild(AreaConstants.NODE_Font);
            if (tagFont) {
                var fontName = tagFont.getAttributeValue(AreaConstants.ATTR_FONT_Name);
                this.textSpan.setStyle('font-family', fontName ? fontName : '');
                
                var isBold = tagFont.getAttributeValueBoolean(AreaConstants.ATTR_FONT_Bold, false);
                this.textSpan.setStyle('font-weight', isBold ? 'bold' : '');

                var isItalic = tagFont.getAttributeValueBoolean(AreaConstants.ATTR_FONT_Italic, false);
                this.textSpan.setStyle('font-font-style', isItalic ? 'italic' : '');

                var size = tagFont.getAttributeValue(AreaConstants.ATTR_FONT_Size);
                this.textSpan.setStyle('font-size', size ? size + 'px' : '');

                var isUnderline = tagFont.getAttributeValueBoolean(AreaConstants.ATTR_FONT_Underline, false);
                var underlineColor = tagFont.getAttributeValue(AreaConstants.ATTR_FONT_UnderlineColor);
                if (isUnderline) {
                    var decoration = "underline";
                    decoration += (underlineColor ? " " + underlineColor : "");
                    this.textSpan.setStyle('text-decoration', decoration);
                } else {
                    this.textSpan.setStyle('text-decoration', '');
                }
            }
        }
    }

    getTagNode(): ITagNode {
        return this.handleTagNode;
    }

    markSelected(b: boolean): void {
        this.selectRange.setVisible(b);
    }

    private left = 0;
    private top = 0;
    setLocation(left: number, top: number, width: number, height: number) {
        this.left = left;
        this.top = top;
        this.setStyle("left", left + "px");
        this.setStyle("top", top + "px");
        this.setWidth(SizeInfo.valueOfPX(width));
        this.setHeight(SizeInfo.valueOfPX(height));
        this.setStyle("line-height", SizeInfo.valueOfPX(height));  //控制垂直方向居中
        this.selectRange.setSize(width, height);
    }

    containPoint(x: number, y: number): boolean {
        return x > this.left && x < this.left + this.getWidth().getValue()
             && y > this.top && y < this.top + this.getHeight().getValue();
    }

    getX(): number {
        return super.getX() < 0 ? 0 : super.getX();
    }

    setX(x: number): void {
        super.setX(x < 0 ? 0 : x);
    }

    getXSpan(): number {
        return super.getXSpan() < 1 ? 1 : super.getXSpan();
    }

    setXSpan(xspan: number): void {
        super.setXSpan(xspan < 1 ? 1 : xspan);
    }

    getY(): number {
        return super.getY() < 0 ? 0 : super.getY();
    }

    setY(y: number): void {
        super.setY(y < 0 ? 0 : y);
    }

    getYSpan(): number {
        return super.getYSpan() < 1 ? 1 : super.getYSpan();
    }

    setYSpan(yspan: number): void {
        super.setYSpan(yspan < 1 ? 1 : yspan);
    }
}

/** 
                <Handle Type="SubAdd|UpDown|Switch|Custom" ExpandStyleClass="" CollapseStyleClass="" X="" Y="" XSpan="" YSpan="" ForeColor="">
                    <Format>
                        <Font Bold="true" Italic="true" Name="Angsana New" Size="11"/>
                    </Format>
                </Handle>
 * 
*/