import AbstractOptStateDelegate from "../../../../common/state/AbstractOptStateDelegate";
import AreaDesignView from "../AreaDesignView";
import MoveState from "./MoveState";
import NormalState from "./NormalState";
import ResizeState from "./ResizeState";

export default class AreaStateDelegate extends AbstractOptStateDelegate<AreaDesignView> {

    private normalState: NormalState;

    private resizeState: ResizeState;

    private moveState: MoveState;

    constructor(designView: AreaDesignView) {
        super(designView);
        this.normalState = new NormalState(this);
        this.resizeState = new ResizeState(this);
        this.moveState = new MoveState(this);
        this.setInitState(this.normalState);
    }

    setNormalState(): void {
        this.setCurrentState(this.normalState);
    }

    setMoveState(): void {
        this.setCurrentState(this.moveState);
    }

    setTopResizeState(): void {
        this.resizeState.setTopResize();
        this.setCurrentState(this.resizeState);
    }

    setBottomResizeState(): void {
        this.resizeState.setBottomResize();
        this.setCurrentState(this.resizeState);
    }

    getDesignView(): AreaDesignView {
        return this.getView();
    }
}