import AbstractOptState from "../../../../common/state/AbstractOptState";
import AreaStateDelegate from "./AreaStateDelegate";
import AreaDesignView from './../AreaDesignView';

export default abstract class AbstractAreaState extends AbstractOptState<AreaDesignView, AreaStateDelegate> {

    protected view: AreaDesignView;

    constructor(delegate: AreaStateDelegate) {
        super(delegate);
        this.view = delegate.getDesignView();
    }

    getViewEl(): HTMLElement {
        return this.view.getEl();
    }

}