import GroupElement from "../../../../common/dom/element/GroupElement";
import PropertyContants from "../../../../design/plugin/property/base/PropertyContants";
import { IPropertyGroup } from "../../../../design/plugin/property/base/PropertyDefine";
import PropertyStateDelegate from "../../../../design/plugin/property/ui/state/PropertyStateDelegate";
import YigoPropertyUIControl from "./YigoPropertyUIControl";

export default class YigoPropertyUIGroup extends GroupElement {

    private propertyGroup: IPropertyGroup;

    private stateDelegate: PropertyStateDelegate;

    constructor(propertyGroup: IPropertyGroup, stateDelegate: PropertyStateDelegate) {
        super(propertyGroup.caption, propertyGroup.expanded);
        this.addClass('property-group');
        this.propertyGroup = propertyGroup;
        this.stateDelegate = stateDelegate;
        this.isExpanded() && this.displayGroup();
    }

    getKey(): string {
        return this.propertyGroup.key;
    }

    protected displayGroup(): void {
        for(let propertyItem of this.propertyGroup.properties) {
            var propertyControl: YigoPropertyUIControl = new YigoPropertyUIControl(propertyItem, this.stateDelegate);
            this.addChild(propertyControl);
            propertyControl.resize(this.getHtmlClientWidth(), PropertyContants.CONTROL_HEIGHT);
        }
    }

    getInnerHeight(): number {
        var total = PropertyContants.CONTROL_HEIGHT; //分组头高度
        for( let child of this.getChildren()) {
            total += PropertyContants.CONTROL_HEIGHT;
        }
        return total;
    }

    resize(width:number, height:number) {
        for( let child of this.getChildren()) {
            child.resize(width, PropertyContants.CONTROL_HEIGHT);
        }
    }

    resizeByRatio(ratio: number): void {
        for( let child of this.getChildren()) {
            if (child instanceof YigoPropertyUIControl) {
                (<YigoPropertyUIControl> child).resizeByRatio(ratio);
            }
        }
    }

    resetHeight(): void {
        this.stateDelegate.getView().resetHeight();
    }
}