import H5HFlexPanel from "../../../common/component/container/panel/H5HFlexPanel";
import FlexLayoutItem from "../../../common/component/container/panel/layout/item/FlexLayoutItem";
import JComponent from "../../../common/component/JComponent";
import PrintToolbar from "./PrintToolbar";

export default class PrintH5HFlexPanel extends H5HFlexPanel {

    private printToolbar: PrintToolbar

    constructor(printToolbar: PrintToolbar,key:string) {
        super();
        this.printToolbar = printToolbar;
        this.setKey(key);

    }

    addComponent(component: JComponent<any>): FlexLayoutItem {
        var flexLayoutItem = super.addComponent(component);
        this.printToolbar.addItems(component.getKey(), component);
        return flexLayoutItem;
    }
}