import CmdQueue from "../../../../common/cmd/CmdQueue";
import DomUtil from "../../../../common/dom/DomUtil";
import DivElement from "../../../../common/dom/element/DivElement";
import SpanElement from "../../../../common/dom/element/SpanElement";
import IXElement from "../../../../common/dom/xelement/IXElement";
import { ENodeType } from "../../../../common/enum/Enums";
import ActionNames from "../../../../common/event/ActionNames";
import Paras from "../../../../common/struct/Paras";
import StringBuilder from "../../../../common/util/StringBuilder";
import INode from "../../../../common/xml/node/INode";
import ITagNode from "../../../../common/xml/node/ITagNode";
import TagNode from "../../../../common/xml/node/TagNode";
import XmlUtil from "../../../../common/xml/util/XmlUtil";
import AbstractXmlEditor from "./AbstractXmlEditor";

/**
 * xml视图
 */
export default class XmlEditor extends AbstractXmlEditor<DivElement> {
    locate(): void {
        
    }

    //private textArea: TextAreaElement;

    //private xmlEntity: IXmlEntity;

    constructor() {
        super(new DivElement());
        this.setStyle('overflow', 'auto');
        this.addClass('xmleditor');
        //this.textArea = new TextAreaElement();
        //this.textArea.addClass('inputarea');
        //this.textArea.setStyle('line-height', '16px');
        this.addEventListener('click', (e: any) => {
            var el: HTMLElement | null =  DomUtil.findParentElByClassName(e.target, "line");
            if (el == null) return;
            
            var line = <XmlLine> this.getDomElement().findElement(el);
            if (line != null) {
                var node = line.getNode();
                if (node.getNodeType() == ENodeType.TAG) {
                    this.xmlEntity.getSelectionModel().select(<TagNode> node);
                }
            }
        }, true);
        /*this.addEventListener('click', function(e: any) {
            e.preventDefault();
            var el: HTMLElement | null =  DomUtil.findParentElByClassName(e.target, "line");
            var line = self.findElement(el);
            if (line) {
                self.textArea.setStyle('top', e.y);
                self.textArea.setStyle('left', e.x);
                line.addChild(self.textArea);
            }
        }, false);*/
    }

    setEditable(editable: boolean): void {
    }

    focus(lineIndex: number): void {
        this.focusedLineIndex = lineIndex;
        var line = this.getDomElement().getChildAt(this.focusedLineIndex);
        line.clearChildren();
        //line.addChild(this.textArea);
    }

    unfocus(): void {
        if (this.focusedLineIndex == -1) return;
        var line = this.getDomElement().getChildAt(this.focusedLineIndex);
        //line.removeChild(this.textArea);
    }

    out(level: number, node: INode, bStart: boolean): void {
        let line = new XmlLine(node, level, bStart);
        line.addClass('line');
        this.getDomElement().addChild(line);
        this.outLine(line, level, node, bStart);
    }

    outLine(line: XmlLine, level: number, node: INode, bStart: boolean): void {
        line.clearChildren();
        line.getEl().innerHTML = "";
        let sb: StringBuilder = new StringBuilder();
        XmlUtil.indentLine4Html(level, sb);
        var indentElem = new SpanElement("");
        indentElem.getEl().innerHTML = sb.toString();
        line.addChild(indentElem);

        if (node.getNodeType() == ENodeType.TAG) {
            let tagNode = <ITagNode> node;

            //结束符号处理
            if (!bStart) {
                let tagEndElem = new SpanElement(`</${tagNode.getTagName()}>`);
                tagEndElem.addClass('tag')
                line.addChild(tagEndElem);
                return;
            }
    
            // 开始符处理
            let tagStartElem = new SpanElement('<' + tagNode.getTagName());
            tagStartElem.addClass('tag');
            line.addChild(tagStartElem);
            level > 0 && line.isStart() && line.select(tagNode.isSelected());
            for (let attr of tagNode.getAttributes()) {
                let attrNameElem = new SpanElement(` ${attr.getKey()}`);
                attrNameElem.addClass('attr-name');
                line.addChild(attrNameElem);
                let eqElem = new SpanElement("=");
                line.addChild(eqElem);

                let attrValueElem = new SpanElement(`"${attr.getValue()}"`);
                attrValueElem.addClass('attr-value');
                line.addChild(attrValueElem);
			}

            if (!tagNode.hasChild()) {
                let elem = new SpanElement("/>");
                elem.addClass('tag')
                line.addChild(elem);
			} else {
                let elem = new SpanElement(">");
                elem.addClass('tag')
                line.addChild(elem);
			}
        } else {
            let elem = new SpanElement(node.getContent());
            elem.addClass(node.getNodeType())
            line.addChild(elem);
        }
    }

    undo(): void {
        this.xmlEntity.undo();
    }

    redo(): void {
        this.xmlEntity.redo();
    }

    reload(): void {
        this.getDomElement().clearChildren();
        this.xmlEntity.getRoot().output(this);
    }

    notifyEvent(cmd: string, paras: Paras): void {
        switch (cmd) {
            case ActionNames.model_node_add:
            case ActionNames.model_node_remove:
                this.reload();
                break;
            case ActionNames.model_node_update:
                var bUpdateAttrOnly = paras.get(Paras.P_UPDATE_ATTR_ONLY);
                this.update(paras.getElement(), false, bUpdateAttrOnly);
                break;
            case ActionNames.model_node_update_select:
                this.update(paras.getElement(), true);
                break;
        }
    }

    refresh(): void {
    }

    update(tagNode: ITagNode, bUpdateSelectOnly: boolean = false, bUpdateAttrOnly: boolean = false): void {
        for (let child of this.getDomElement().getChildren()) {
            if (child instanceof XmlLine) {
                var line = <XmlLine> child;
                if (line.getNode() == tagNode) {
                    if (!bUpdateSelectOnly) {
                        this.outLine(line, line.getLevel(), tagNode, line.isStart());
                        if (!bUpdateAttrOnly) {
                            for (let node of tagNode.getChildren()) {
                                if (node instanceof TagNode) {
                                    this.update(node);
                                }
                            }
                        }
                    }   
                    line.isStart() && line.select(tagNode.isSelected())
                } else {
                    line.select(false);
                }
            }
        }
    }

    resize(width: any, height: any): void {}
    
    commit(): boolean {
        return true;
    }

    isChanged(): boolean {
        return false;
    }
}

class XmlLine extends DivElement {

    private node: INode;

    private level: number;

    private start: boolean;

    constructor(node: INode, level: number, start: boolean) {
        super();
        this.node = node;
        this.level = level;
        this.start = start;
    }

    select(selected: boolean): void {
        selected ? this.addClass('line-selected') : this.removeClass('line-selected');
    }

    isStart(): boolean {
        return this.start;
    }

    getNode(): INode {
        return this.node;
    }

    getLevel(): number {
        return this.level;
    }

}