import CmdQueue from "../../../../common/cmd/CmdQueue";
import AbstractDomElement from "../../../../common/dom/AbstractDomElement";
import ActionNames from "../../../../common/event/ActionNames";
import IEventListener from "../../../../common/listener/IEventListener";
import Paras from "../../../../common/struct/Paras";
import { IDesignView } from "../../../../common/view/IDesignView";
import IXmlEntity from "../../../../common/xml/IXmlEntity";
import INode from "../../../../common/xml/node/INode";
import ITagNode from "../../../../common/xml/node/ITagNode";
import INodeOutput from "../../../../common/xml/output/INodeOutput";
import XmlEntity from "../../../../common/xml/XmlEntity";
import AbstractEditor from "../AbstractEditor";

/**
 * xml视图
 */
 export default abstract class AbstractXmlEditor<T extends AbstractDomElement> extends AbstractEditor<T> implements IDesignView, INodeOutput, IEventListener {

    protected focusedLineIndex: number = -1;

    protected xmlEntity: IXmlEntity;

    private visible: boolean = false;

    constructor(domElement: T) {
        super(domElement);
        this.xmlEntity = new XmlEntity();
        this.addClass('xmleditor');
    }

    notifyEvent(cmd: string, paras: Paras): void {
        switch (cmd) {
            case ActionNames.model_node_add:
            case ActionNames.model_node_remove:
                this.reload();
                break;
            case ActionNames.model_node_update:
                var bUpdateAttrOnly = paras.get(Paras.P_UPDATE_ATTR_ONLY);
                this.update(paras.getElement(), false, bUpdateAttrOnly, true);
                break;
            case ActionNames.model_node_update_select:
                this.update(paras.getElement(), true, false, false);
                break;
        }
    }

    load(xmlEntity: IXmlEntity): void {
        this.xmlEntity = xmlEntity;
        this.reload();
    }

    setVisible(visible: boolean): void {
        this.visible = visible;
    }

    isVisible(): boolean {
        return this.visible;
    }

    abstract setEditable(editable: boolean): void;

    abstract refresh(): void;

    abstract reload(): void;

    abstract update(tagNode: ITagNode, bUpdateSelectOnly: boolean , bUpdateAttrOnly: boolean, bNeedUpdateNodeXml: boolean): void;
    
    abstract out(level: number, node: INode, bStart: boolean): void;

    abstract resize(width: any, height:any): void;

    abstract undo(): void;

	abstract redo(): void;

    abstract commit(): boolean;

    abstract isChanged(): boolean;

}
