import SpanElement from "../../../../common/dom/element/SpanElement";
import IExcelElementView from "./IExcelElementView";
import AbstractDomElement from "../../../../common/dom/AbstractDomElement";
import ITagNode from "../../../../common/xml/node/ITagNode";
import DomElement from "../../../../common/dom/element/DomElement";
import {EHAlign, EUnderLineStyle, EVAlign} from "../../../../common/enum/Enums";
import ExcelConstants from "../../base/ExcelConstants";
import BaseConstants from "../../../base/BaseConstants";
import PRINT from "../../../print/base/PRINT";
import EXCEL from "../../base/EXCEL";
import P18N from "../../base/P18N";
import TextEditor from "../../../../common/component/control/TextEditor";
import ExcelGraphicView from "../ExcelGraphicView";
import SheetView from "./SheetView";

export class ExcelCellView extends SpanElement implements IExcelElementView {

    private tDisplay: TDisplay;

    private tFont: TFont;

    private tBorder: TBorder;
    private cellVisible: boolean = true;
    private imageDomElement?: DomElement;
    private textEditor?: TextEditor;

    private colindex: number;
    private rowindex: number;
    private MegerHeadColindex: number = 0;
    private MegerHeadRowindex: number = 0;
    private isTh: boolean = false;
    private tagCell?: ITagNode;


    constructor(rowindex: number, colindex: number) {
        super();
        var span = new DomElement(this.getEl());
        if (colindex - 1 < 0) {
            this.isTh = true
        }

        span.setAttr("rowindex", String(rowindex));
        span.setAttr("colindex", String(colindex));
        this.tDisplay = new TDisplay();
        this.tFont = new TFont();
        this.tBorder = new TBorder();
        this.rowindex = rowindex;
        this.colindex = colindex;

        this.prepareTDisplay();
    }

    getCellVisible(): boolean {
        return this.cellVisible;
    }

    setCellVisible(cellVisible: boolean): void {

        this.cellVisible = cellVisible;
    }

    getTextEditor(): TextEditor {
        return this.textEditor!;
    }

    getMegerHeadColindex(): number {
        return this.MegerHeadColindex;
    }

    setMegerHeadColindex(MegerHeadColindex: number): void {

        this.MegerHeadColindex = MegerHeadColindex;
    }

    getMegerHeadRowindex(): number {
        return this.MegerHeadRowindex;
    }

    setMegerHeadRowindex(MegerHeadRowindex: number): void {

        this.MegerHeadRowindex = MegerHeadRowindex;
    }

    getRowIndex(): number {
        return this.rowindex;
    }

    getColIndex(): number {
        return this.colindex;
    }

    setTagCell(tagNode: ITagNode): void {
        this.tagCell = tagNode;
    }

    getTagNode(): ITagNode | undefined {
        return this.tagCell;
    }

    containPoint(x: number, y: number): boolean {
        return false;
    }

    prepareTDisplay() {
        if (!this.tagCell) {
            return;
        }
        var tagDisplay = this.tagCell.getChild(BaseConstants.NODE_Display);
        tagDisplay && this.tDisplay.init(tagDisplay);

        var tagFont = tagDisplay ? tagDisplay.getChild(BaseConstants.NODE_Font) : undefined;
        tagFont && this.tFont.init(tagFont);

        var tagBorder = tagDisplay ? tagDisplay.getChild(BaseConstants.NODE_Border) : undefined;
        tagBorder && this.tBorder.init(tagBorder);
    }

    getDomElement(): AbstractDomElement {
        return this;
    }

    getMergedColumnSpan(): string {
        if (!this.tagCell) {
            return ""
        }
        return this.tagCell.getAttributeValue(BaseConstants.ATTR_ColSpan);
    }

    getMergedRowSpan(): string {
        if (!this.tagCell) {
            return ""
        }
        return this.tagCell.getAttributeValue(BaseConstants.ATTR_RowSpan);
    }

    isEmbed(): boolean {
        return false;
    }

    getCaption(): string {
        if (!this.tagCell) {
            return "";
        }
        var value = this.tagCell.getAttributeValue("Definition", "");
        var sourceType = this.tagCell.getAttributeValue("SourceType", "");
        if (value !== "" && sourceType !== "Const" && sourceType !== "Formula") {
            return "[" + value + "]"
        }
        if (value !== "" && sourceType === "Formula") {
            return "=" + value
        }
        return value;
    }

    getDefinition(): string {
        if (!this.tagCell) {
            return "";
        }
        var value = this.tagCell.getAttributeValue("Definition");
        return value;
    }

    updateMultiView(excelGraphicView: ExcelGraphicView): void {
        if (!this.tagCell) {
            return;
        }
        var containerEl = this.parentEl();
        this.setStyle('display', "block");
        if (containerEl) {//td
            var selectSheetView = <SheetView>excelGraphicView.getSelectSheetView();
            var thChildRow;
            var thChildCol;
            if (selectSheetView) {
                thChildRow = selectSheetView.getRowChildThNode(this.rowindex);
                thChildCol = selectSheetView.getChildThNode(this.colindex);
            }
            var container = new DomElement(containerEl);
            if (this.tagCell.isSelected()) {
                container.addClass('selected');
            } else {
                container.removeClass('selected');
                if (this.imageDomElement && !this.tagCell.getParent()) {
                    container.removeChild(this.imageDomElement);
                    this.imageDomElement = undefined;
                }
                if (this.textEditor) {
                    var input = new DomElement(this.textEditor.getEl());
                    container.removeChild(input);
                    this.textEditor = undefined;
                }
                if (thChildRow) {
                    thChildRow.removeClass("selected");

                }
                if (thChildCol) {
                    thChildCol.removeClass("selected");
                }
            }
            return;
        }
    }

    updateView(excelGraphicView: ExcelGraphicView): void {
        if (!this.tagCell) {
            return;
        }
        this.prepareTDisplay();
        this.setText(this.getCaption());
        this.setStyle('display', "block");
        this.setAttr("value", this.getDefinition())
        var containerEl = this.parentEl();
        if (containerEl) {//td
            var container = new DomElement(containerEl);
            var selectSheetView = <SheetView>excelGraphicView.getSelectSheetView();
            var thChildRow;
            var thChildCol;
            if (selectSheetView) {
                thChildRow = selectSheetView.getRowChildThNode(this.rowindex);
                thChildCol = selectSheetView.getChildThNode(this.colindex);
            }

            if (this.tagCell.isSelected()) {
                if (thChildRow) {
                    thChildRow.addClass("selected");

                }
                if (thChildCol) {
                    thChildCol.addClass("selected");

                }
                container.addClass('selected');
                if (!this.imageDomElement) {
                    var image = new DomElement(new Image(16, 16));
                    image.setAttr("src", EXCEL.PREFIX + "/css/img/ExcelSelect.png");
                    image.setAttr("rowindex", String(this.rowindex));
                    image.setAttr("colindex", String(this.colindex));
                    image.addClass("selected-td-img");
                    container.addChild(image);
                    this.imageDomElement = image;
                }
                if (!this.textEditor) {
                    this.textEditor = new TextEditor();
                    this.textEditor.setStyle("display", "none");
                    var input = new DomElement(this.textEditor.getEl());
                    input.setAttr("rowindex", String(this.rowindex));
                    input.setAttr("colindex", String(this.colindex));
                    container.addChild(input);
                    var sefl = excelGraphicView;
                    this.textEditor.addEventListener("blur", (e: any) => {
                        var target = <HTMLElement>e.target;
                        target.style.backgroundColor = "#DDDDDD";
                        sefl.initInputState(sefl, e);
                        setTimeout(function () {
                            sefl.getOptStateDelegate().setNormalState();
                        }, 100)
                    });
                    this.textEditor.addEventListener("focus", (e: any) => {
                        sefl.getOptStateDelegate().setInputState();
                    });
                }


            } else {
                if (thChildRow) {
                    thChildRow.removeClass("selected");

                }
                if (thChildCol) {
                    thChildCol.removeClass("selected");
                }


                container.removeClass('selected');
                if (this.imageDomElement && !this.tagCell.getParent()) {
                    container.removeChild(this.imageDomElement);
                    this.imageDomElement = undefined;
                } else if (this.imageDomElement && this.tagCell.getParent()) {
                    container.addChild(this.imageDomElement);
                } else if (this.tagCell.getParent()) {
                    var image = new DomElement(new Image(16, 16));
                    image.setAttr("src", EXCEL.PREFIX + "/css/img/ExcelSelect.png");
                    image.setAttr("rowindex", String(this.rowindex));
                    image.setAttr("colindex", String(this.colindex));
                    image.addClass("selected-td-img");
                    container.addChild(image);
                    this.imageDomElement = image;
                }
                if (this.textEditor) {
                    var input = new DomElement(this.textEditor.getEl());
                    container.removeChild(input);
                    this.textEditor = undefined;
                }
            }
            if (!this.tagCell.getParent()) {
                return;
            }
            var backColor = P18N.getColorString(this.tDisplay.getBackColor());
            container.setStyle('background-color', backColor);
            //    container.setStyle("background", 'no-repeat');
            //  container.setStyle("background-image", 'url(./css/img/ExcelSelect.png)');
            //  container.setStyle("background-position-x", 'right');
            //   container.setStyle("background-position-y", 'top');
            var foreColor = P18N.getColorString(this.tDisplay.getForeColor());
            this.setStyle('color', foreColor);

            var hAlign = this.tDisplay.getHAlign();
            var vAlign = this.tDisplay.getVAlign();
            switch (hAlign) {
                case EHAlign.Left:
                    container.setStyle('text-align', 'left');
                    break;
                case EHAlign.Center:
                    container.setStyle('text-align', 'center');
                    break;
                case EHAlign.Right:
                    container.setStyle('text-align', 'right');
                    break;
            }
            switch (vAlign) {
                case EVAlign.Top:
                    container.setStyle('vertical-align', 'top');
                    break;
                case EVAlign.Center:
                    container.setStyle('vertical-align', 'middle');
                    break;
                case EVAlign.Bottom:
                    container.setStyle('vertical-align', 'bottom');
                    break;
            }
            var bottomColor = P18N.getColorString(this.tBorder.getBottomColor());
            var leftColor = P18N.getColorString(this.tBorder.getLeftColor());
            var rightColor = P18N.getColorString(this.tBorder.getRightColor());
            var topColor = P18N.getColorString(this.tBorder.getTopColor());


            container.setStyle('border-bottom-color', bottomColor);
            container.setStyle('border-right-color', rightColor);
            container.setStyle('border-left-color', leftColor);
            container.setStyle('border-top-color', topColor);


            let bottomStyle = this.tBorder.getBottomStyle();
            switch (bottomStyle) {
                case "0":
                    //无线
                    container.setStyle('border-bottom-style', "dotted");
                    container.setStyle('border-bottom-color', "#E0E0E0");
                    container.setStyle('border-bottom-width', 'thin');
                    break;
                case "Thin":
                    //"solid"//实线
                    container.setStyle('border-bottom-style', "solid");
                    container.setStyle('border-bottom-width', 'thin');
                    break;
                case "Dashed":
                    //"solid"//实线
                    container.setStyle('border-bottom-style', "dashed");
                    container.setStyle('border-bottom-width', 'thin');
                    break;
                case "Double":
                    //"dotted"//点状
                    container.setStyle('border-bottom-style', "double");
                    break;
                case "Hair":
                    //"solid"//加粗实线
                    container.setStyle('border-bottom-style', 'dotted');
                    container.setStyle('border-bottom-width', "solid");
                    break;
                case "Medium":
                    //"solid"//加粗实线
                    container.setStyle('border-bottom-style', 'solid');
                    container.setStyle('border-bottom-width', "medium");
                    break;
                case "Thick":
                    //"solid"//加粗实线
                    container.setStyle('border-bottom-style', 'solid');
                    container.setStyle('border-bottom-width', "thick");
                    break;
                default:
                    container.setStyle('border-bottom-style', "none");
                    break;
            }

            var leftStyle = this.tBorder.getLeftStyle();
            switch (leftStyle) {
                case "0":
                    container.setStyle('border-left-style', "dotted");
                    container.setStyle('border-left-color', "#E0E0E0");
                    container.setStyle('border-left-width', 'thin');
                    break;
                case "Thin":
                    //"solid"//实线
                    container.setStyle('border-left-style', "solid");
                    container.setStyle('border-left-width', 'thin');
                    break;
                case "Dashed":
                    //"solid"//实线
                    container.setStyle('border-left-style', "dashed");
                    container.setStyle('border-left-width', 'thin');
                    break;
                case "Double":
                    //"dotted"//点状
                    container.setStyle('border-left-style', "double");
                    break;
                case "Hair":
                    //"solid"//加粗实线
                    container.setStyle('border-left-style', 'dotted');
                    container.setStyle('border-left-width', "solid");
                    break;
                case "Medium":
                    //"solid"//加粗实线
                    container.setStyle('border-left-style', 'solid');
                    container.setStyle('border-left-width', "medium");
                    break;
                case "Thick":
                    //"solid"//加粗实线
                    container.setStyle('border-left-style', 'solid');
                    container.setStyle('border-left-width', "thick");
                    break;
                default:
                    container.setStyle('border-left-style', "none");
                    break;
            }
            var rightStyle = this.tBorder.getRightStyle();
            switch (rightStyle) {
                case "0":
                    container.setStyle('border-right-style', "dotted");
                    container.setStyle('border-right-color', "#E0E0E0");
                    container.setStyle('border-right-width', 'thin');
                    break;
                case "Thin":

                    container.setStyle('border-right-style', "solid");
                    container.setStyle('border-right-width', 'thin');
                    break;
                case "Dashed":

                    container.setStyle('border-right-style', "dashed");
                    container.setStyle('border-right-width', 'thin');
                    break;
                case "Double":
                    container.setStyle('border-right-style', "double");
                    break;
                case "Hair":
                    container.setStyle('border-right-style', 'dotted');
                    container.setStyle('border-right-width', "solid");
                    break;
                case "Medium":

                    container.setStyle('border-right-style', 'solid');
                    container.setStyle('border-right-width', "medium");
                    break;
                case "Thick":

                    container.setStyle('border-right-style', 'solid');
                    container.setStyle('border-right-width', "thick");
                    break;
                default:
                    container.setStyle('border-right-style', "none");
                    break;
            }
            var topStyle = this.tBorder.getTopStyle();
            switch (topStyle) {
                case "0":
                    container.setStyle('border-top-style', "dotted");
                    container.setStyle('border-top-color', "#E0E0E0");

                    container.setStyle('border-top-width', 'thin');
                    break;
                case "Thin":
                    //"solid"//实线
                    container.setStyle('border-top-style', "solid");
                    container.setStyle('border-top-width', 'thin');
                    break;
                case "Dashed":
                    //"solid"//实线
                    container.setStyle('border-top-style', "dashed");
                    container.setStyle('border-top-width', 'thin');
                    break;
                case "Double":
                    //"dotted"//点状
                    container.setStyle('border-top-style', "double");
                    break;
                case "Hair":
                    //"solid"//加粗实线
                    container.setStyle('border-top-style', 'dotted');
                    container.setStyle('border-top-width', "solid");
                    break;
                case "Medium":
                    //"solid"//加粗实线
                    container.setStyle('border-top-style', 'solid');
                    container.setStyle('border-top-width', "medium");
                    break;
                case "Thick":
                    //"solid"//加粗实线
                    container.setStyle('border-top-style', 'solid');
                    container.setStyle('border-top-width', "thick");
                    break;
                default:
                    container.setStyle('border-top-style', "none");
                    break;
            }

            container.setAttr('colspan', this.getMergedColumnSpan());
            container.setAttr('rowspan', this.getMergedRowSpan());
            if (!this.cellVisible) {
                container.addClass("divisioncell");
            } else {
                container.removeClass("divisioncell");
            }
            container.setAttr("rowindex", String(this.rowindex));
            container.setAttr("colindex", String(this.colindex));
        }
        this.setStyle('font-family', this.tFont.getName());
        this.setStyle('font-weight', this.tFont.isBold() ? 'bold' : '');
        this.setStyle('font-style', this.tFont.isItalic() ? 'italic' : '');
        this.setStyle('font-size', this.tFont.getSize() + 'px');
        if (this.tFont.getUnderLine() == "None") {
            this.setStyle('text-decoration', "none");
            this.setStyle('border-bottom', "");
        } else if (this.tFont.getUnderLine() == "SolidNormal") {
            this.setStyle('text-decoration-line', "underline");
            this.setStyle('border-bottom', "");
            this.setStyle('text-decoration-style', "solid");
        } else if (this.tFont.getUnderLine() == "Dashed") {
            this.setStyle('border-bottom', "");
            this.setStyle('text-decoration-line', "underline");
            this.setStyle('text-decoration-style', "dashed");
        } else if (this.tFont.getUnderLine() == "SolidBold") {
            this.setStyle('text-decoration-line', "underline");
            this.setStyle('text-decoration-style', "solid");
            this.setStyle('border-bottom', "1px solid");
        }

    }

    addClass(cls: string) {
        super.addClass(cls);
        var containerEl = this.parentEl();
        if (containerEl) {//td
            var container = new DomElement(containerEl);
            container.addClass(cls)
        }
    }

    findChildNode(tagNode: ITagNode): IExcelElementView | undefined {
        return undefined;
    }

}

class TDisplay {

    private tagDisplay!: ITagNode;

    init(tagDisplay: ITagNode) {
        this.tagDisplay = tagDisplay;
    }

    getHAlign(): string {
        if (!this.tagDisplay) return EHAlign.Center;
        return this.tagDisplay.getAttributeValue(ExcelConstants.ATTR_HAlign, EHAlign.Center);
    }

    getVAlign(): string {
        if (!this.tagDisplay) return EVAlign.Center;
        return this.tagDisplay.getAttributeValue(ExcelConstants.ATTR_VAlign, EVAlign.Center);
    }

    getBackColor(): string {
        if (!this.tagDisplay) return "";
        return this.tagDisplay.getAttributeValue(BaseConstants.ATTR_BackColor, "");
    }

    getForeColor(): string {
        if (!this.tagDisplay) return "";
        return this.tagDisplay.getAttributeValue(BaseConstants.ATTR_ForeColor, "");
    }
}

class TFont {

    private tagFont!: ITagNode;

    init(tagFont: ITagNode) {
        this.tagFont = tagFont;
    }

    getName(): string {
        if (!this.tagFont) return PRINT.D_FONT_NAME;
        return this.tagFont.getAttributeValue(BaseConstants.ATTR_Name, PRINT.D_FONT_NAME);
    }

    getSize(): number {
        if (!this.tagFont) return PRINT.D_FONT_SIZE;
        return this.tagFont.getAttributeValueInt(BaseConstants.ATTR_FONT_Size, PRINT.D_FONT_SIZE);
    }

    isBold(): boolean {
        if (!this.tagFont) return false;
        return this.tagFont.getAttributeValueBoolean(BaseConstants.ATTR_FONT_Bold, false);
    }

    isItalic(): boolean {
        if (!this.tagFont) return false;
        return this.tagFont.getAttributeValueBoolean(BaseConstants.ATTR_FONT_Italic, false);
    }

    getUnderLine(): string {
        if (!this.tagFont) return EUnderLineStyle.None;
        return this.tagFont.getAttributeValue(BaseConstants.ATTR_FONT_Underline, EUnderLineStyle.None);
    }

    /*
        private String name = "";
        private int size = -1;
        private boolean bold = false;
        private boolean italic = false;
        private int underlineStyle = ReportUnderLineStyle.None;
         */
    /*  var foreColor = tagFormat.getAttributeValue(AreaConstants.ATTR_ForeColor);
     this.textSpan.setStyle('color', foreColor ? foreColor : '');
     var tagFont = tagFormat.getChild(AreaConstants.NODE_Font);
     if (tagFont) {
         var fontName = tagFont.getAttributeValue(AreaConstants.ATTR_FONT_Name);
         this.textSpan.setStyle('font-family', fontName ? fontName : '');

         var isBold = tagFont.getAttributeValueBoolean(AreaConstants.ATTR_FONT_Bold, false);
         this.textSpan.setStyle('font-weight', isBold ? 'bold' : '');

         var isItalic = tagFont.getAttributeValueBoolean(AreaConstants.ATTR_FONT_Italic, false);
         this.textSpan.setStyle('font-font-style', isItalic ? 'italic' : '');

         var size = tagFont.getAttributeValue(AreaConstants.ATTR_FONT_Size);
         this.textSpan.setStyle('font-size', size ? size + 'px' : ''); */
}

class TBorder {
    private tagBorder!: ITagNode;

    init(tagBorder: ITagNode) {
        this.tagBorder = tagBorder;
    }

    getLeftColor(): string {
        if (!this.tagBorder) return ""
        return this.tagBorder.getAttributeValue(BaseConstants.ATTR_LEFTCOLOR, "");
    }

    getBottomColor(): string {
        if (!this.tagBorder) return ""
        return this.tagBorder.getAttributeValue(BaseConstants.ATTR_BOTTOMCOLOR, "");
    }

    getRightColor(): string {
        if (!this.tagBorder) return ""
        return this.tagBorder.getAttributeValue(BaseConstants.ATTR_RIGHTCOLOR, "");
    }

    getTopColor(): string {
        if (!this.tagBorder) return ""
        return this.tagBorder.getAttributeValue(BaseConstants.ATTR_TDPCOLOR, "");
    }

    getBottomStyle(): string {
        if (!this.tagBorder) return "0"
        return this.tagBorder.getAttributeValue(BaseConstants.ATTR_BOTTOMSTYLE, "0");
    }

    getTopStyle(): string {
        if (!this.tagBorder) return "0"
        return this.tagBorder.getAttributeValue(BaseConstants.ATTR_TOPSTYLE, "0");
    }

    getRightStyle(): string {
        if (!this.tagBorder) return "0"
        return this.tagBorder.getAttributeValue(BaseConstants.ATTR_RIGHTSTYLE, "0");
    }

    getLeftStyle(): string {
        if (!this.tagBorder) return "0"
        return this.tagBorder.getAttributeValue(BaseConstants.ATTR_LEFTSTYLE, "0");
    }


}
