import ExcelGraphicView from "../view/ExcelGraphicView";
import ITagNode from "../../../common/xml/node/ITagNode";
import ICmd from "../../../common/cmd/ICmd";
import ExcelConstants from "../base/ExcelConstants";
import BaseConstants from "../../base/BaseConstants";
import XmlEntity from "../../../common/xml/XmlEntity";
import SheetView from "../view/element/SheetView";


export default class DeleteColumnElementCmd implements ICmd {


    private cmd: String;
    private view: ExcelGraphicView;
    private tagNodes: ITagNode;
    private orgtagNodes?: ITagNode[];
    private newITagNodes?: ITagNode[];
    private deleteNode?: ITagNode[];


    constructor(view: ExcelGraphicView, tagNodes: ITagNode[], cmd: String) {
        this.view = view;
        this.tagNodes = tagNodes[tagNodes.length - 1];
        this.cmd = cmd;
    }

    do(): boolean {
        let xmlEntity = this.view.getXmlEntity();
        let cellNode = this.tagNodes;
        let selectSheetViewName = this.view.getSelectSheetViewName();
        let rowNode = <ITagNode>cellNode.getParent();
        let columnIndex: number = 0
        if (rowNode) {
            columnIndex = Number(cellNode.getAttributeValue("CellIndex"));
        } else {
            columnIndex = Number(cellNode.getAttributeValue("colindex")) + 1;
        }
        this.orgtagNodes = this.orgtagNodes || [];
        this.newITagNodes = this.newITagNodes || [];
        this.deleteNode = this.deleteNode || [];
        let tagRoot = xmlEntity.getTagRoot();
        let children = tagRoot.getChildren();
        let sheetNode: ITagNode = cellNode;
        for (let child of children) {
            let sheet = <ITagNode>child;
            let key = sheet.getAttributeValue(BaseConstants.ATTR_Name);
            if (key == selectSheetViewName) {
                sheetNode = sheet;
                break;
            }
        }
        let rowsNode = <ITagNode>sheetNode.getChildren()[0];
        let rows = rowsNode!.getChildren();
        for (let row of rows) {
            let rownode = <ITagNode>row;
            let cells = rownode.getChildren();
            for (let cell of cells) {
                let cellNode = <ITagNode>cell;
                let cellIndex = Number(cellNode.getAttributeValue("CellIndex"));
                let columnSpan: number = Number(cellNode.getAttributeValue(ExcelConstants.ATTR_MergedColumnSpan));//合并列处理
                if (cellIndex > columnIndex) {
                    this.orgtagNodes.push(XmlEntity.parseTagNode(cellNode.toXml(true)));
                    cellNode.setAttributeValue("CellIndex", (cellIndex - 1).toString())
                    this.newITagNodes.push(cellNode);
                } else if (cellIndex == columnIndex) {
                    let colSpan: number = Number(cellNode.getAttributeValue(ExcelConstants.ATTR_MergedColumnSpan));//合并行处理
                    if (colSpan && colSpan > 1) {
                        this.orgtagNodes.push(XmlEntity.parseTagNode(cellNode.toXml(true)));
                        cellNode.setAttributeValue(ExcelConstants.ATTR_MergedColumnSpan, (colSpan - 1).toString());
                        this.newITagNodes.push(cellNode);
                    }else {
                        this.deleteNode.push(cellNode);
                    }
                } else if (columnSpan && (cellIndex + columnSpan) > columnIndex) {
                    this.orgtagNodes.push(XmlEntity.parseTagNode(cellNode.toXml(true)));
                    let colSpan: number = Number(cellNode.getAttributeValue(ExcelConstants.ATTR_MergedColumnSpan));//合并行处理
                    cellNode.setAttributeValue(ExcelConstants.ATTR_MergedColumnSpan, (colSpan - 1).toString());
                    this.newITagNodes.push(cellNode);
                }
            }
        }
        var selectionModel = this.view.getXmlEntity().getSelectionModel();
        var selectSheetView = <SheetView>this.view.getSelectSheetView();
        selectionModel.select(selectSheetView.getTagNode());
        for (let node of this.deleteNode) {
            xmlEntity.removeNode(node)
        }
        return true;
    }


    undo(): void {
        if (!(this.orgtagNodes && this.orgtagNodes!.length > 0)) {
            return;
        }
        for (let i = 0; i < this!.newITagNodes!.length; i++) {
            var attributes = this!.newITagNodes![i]!.getAttributes();
            attributes.length = 0;
            for (let j = 0; j < this.orgtagNodes[i].getAttributes().length; j++) {
                attributes.push(this.orgtagNodes[i].getAttributes()[j]);
            }
            let xmlEntity = this.view.getXmlEntity();
            xmlEntity.update(this!.newITagNodes![i], true);
        }
        if (this.deleteNode && this.deleteNode.length>0){
            for (let iTagNode of this.deleteNode) {
                let node = <ITagNode>iTagNode;
                node.getParent()!.getChildren().push(node);
            }
        }

        var selectionModel = this.view.getXmlEntity().getSelectionModel();
        var selectSheetView = <SheetView>this.view.getSelectSheetView();
        selectionModel.select(selectSheetView.getTagNode());
    }

}