import AbstractResourceLoader from "../../plugin/loader/AbstractResourceLoader";

export default class EXCEL {
    public static D_TH_COLUMN_WIDTH = 35;
    public static D_TH_COLUMN_HEIGHT = 60;
    public static D_COLUMN_WIDTH = 80;
    public static D_MAX_ROW_SIZE = 31;
    public static D_MAX_COL_SIZE = 31;
    public static PREFIX = YIUI.webRoot ? "./yesui-vnode" : "../../../webpluginx";//"../../../webpluginx";//".""designer"
    public static D_ROW_HEIGHT = 40;

    public static D_ROW_Type = "Fix";

    public static D_FONT_NAME = "SimSun";

    public static D_FONT_SIZE = 12;

    public static PROPERTIES_XML: string =
        `<EXCEL>
<DefineCollection>
    <Define Key="Workbook" Caption="EXCEL模板" Extends="">
        <PropertyCollection>
            <Property Key="Key" Caption="标志" Control="TextEditor" Editable = "false"/>
            <Property Key="Caption" Caption="名称" Control="TextEditor"/>
            <Property Key="FormKey" Caption="绑定表单" Control="ButtonEditor" OnButtonClick="Macro_ShowWorkflowBindDialog()" Editable = "false"/>
        </PropertyCollection>
    </Define>
    <Define Key="Sheet" Caption="页" Extends="">
        <PropertyCollection>
            <Property Key="Name" Caption="名称" Control="TextEditor"/>
        </PropertyCollection>
    </Define>
    <Define Key="Column" Caption="列属性" Extends="">
        <PropertyCollection>
            <Property Key="ColumnIndex" Caption="列号" Control="NumberEditor" Editable = "false"/>
            <Property Key="Width" Caption="宽度" Control="NumberEditor" DefaultValue="80"/>
        </PropertyCollection>
    </Define>
    <Define Key="Row" Caption="行属性" Extends="">
        <PropertyCollection>
            <Property Key="Type" Caption="类型" Control="Combobox" OnInitialize="Head,表头数据行;DetailHead,明细头;Detail,明细行;Group,分组行;Fix,固定行;" DefaultValue="Fix"/>
            <Property Key="RowIndex" Caption="行号" Control="NumberEditor" Editable = "false"/>
            <Property Key="GridKey" Caption="表标志" Control="TextEditor"/>
            <Property Key="TableKey" Caption="数据源表" Control="Combobox" OnInitialize="=Macro_GetTableKeyList(GetRefFormKey(),GetRowType())" Visible="GetRowType()=='Detail'" />
            <Property Key="GroupDefination" Caption="分组字段" Control="TextEditor" />
            <Property Key="GroupLevel" Caption="分组层级" Control="NumberEditor" DefaultValue="0"/>
            <Property Key="GroupPosition" Caption="分组行位置" Control="Combobox" OnInitialize="head,head;tail,tail;all,all;"/>
            <Property Key="GroupHeadRowCount" Caption="头部分组行的个数" Control="NumberEditor" DefaultValue="0" />
            <Property Key="GroupTailRowCount" Caption="尾部分组行的个数" Control="NumberEditor" DefaultValue="0" />
        </PropertyCollection>
    </Define>
    <Define Key="Cell" Caption="单元格属性" Extends="">
        <PropertyCollection>
            <Property Key="CellIndex" Caption="单元格列号" Control="NumberEditor" DefaultValue="-1" Editable = "false"/>
            <Property Key="SourceType" Caption="内容类型" Control="Combobox" OnInitialize="Field,字段;Formula,公式;Const,常量;" DefaultValue="Field"/>
            <Property Key="Definition" Caption="内容" Control="ButtonEditor" OnButtonClick='Macro_ShowFormulaDialog("{self.key}",{{self.value}})'/>
            <Property Key="MergedColumnSpan" Caption="占用列数" Control="NumberEditor" DefaultValue="1"/>
            <Property Key="MergedRowSpan" Caption="占用行数" Control="NumberEditor" DefaultValue="1"/>
            <Property Key="ColumnExpand" Caption="是否扩展" Control="ButtonEditor" OnButtonClick="ShowModal('D_ExcelColumnExpand',{FormKey:{GetPrintAttrValue('FormKey')},ExcelKey:{GetPrintAttrValue('Key')}, XML:{GetSheetXML()}, ColumnIndex:{GetExcelColumnIndex()},RowIndex: {GetExcelRowIndex()}});" />
            <Property Key="TableKey" Caption="对应数据源标识" Control="Combobox" OnInitialize="=Macro_GetTableKeys(GetRefFormKey())" />
            <Property Key="GroupLevel" Caption="分组级别" Control="NumberEditor" DefaultValue="0"  />
            <Property Key="GroupPosition" Caption="分组行位置" Control="Combobox" OnInitialize="head,head;tail,tail;all,all;"/>
            <Property Key="GroupHeadRowCount" Caption="头部分组行的个数" Control="NumberEditor" DefaultValue="0" />
            <Property Key="GroupTailRowCount" Caption="尾部分组行的个数" Control="NumberEditor" DefaultValue="0" />
        </PropertyCollection>
    </Define>
</DefineCollection>
</EXCEL>
`;
}