import GlobalConstants from "../../../../common/struct/GlobalConstants";
import RectBound from "../../../../common/struct/RectBound";
import { Area } from "../../../../common/struct/Structs";
import IGElement from "../../../../common/ui/graphic/IGElement";

import ITagNode from "../../../../common/xml/node/ITagNode";
import TagNode from "../../../../common/xml/node/TagNode";
import BaseConstants from "../../../base/BaseConstants";
import I18N from "../../../bpm/base/I18N";
import IGTable from "../../../../common/ui/graphic/IGTable";

export default abstract class AbstractMigrationElement {

    protected gSection!: IGTable;

    protected xmlNode: ITagNode;

    //private xmlGraphicNode!: ITagNode | null;
    protected optHandler?: (event: MouseEvent) => void;

    protected dblClickHandler?: (event: MouseEvent) => void;

    private gCaptionElement?: IGElement;

    constructor(xmlNode?: ITagNode) {
        this.xmlNode = xmlNode ? xmlNode : new TagNode(this.getType());
        if(!this.getCaption()) {
            this.setCaption(this.getDefaultCaption());
        }
    }

    getID(): string {
        return this.xmlNode.getAttributeValue(GlobalConstants.S_ID);
    }

    setID(id: string): void {
        this.xmlNode.setAttributeValue(GlobalConstants.S_ID, id);
    }

    getKey(): string {
        return this.xmlNode.getAttributeValue(GlobalConstants.S_Key);
    }

    setKey(key: string): void {
        this.xmlNode.setAttributeValue(GlobalConstants.S_Key, key);
    }

    getCaption(): string {
        return this.xmlNode.getAttributeValue(GlobalConstants.S_Caption);
    }

    setCaption(caption: string): void {
        this.xmlNode.setAttributeValue(GlobalConstants.S_Caption, caption);
    }

    getGSection(): IGTable {
        return this.gSection;
    }


    
    updataView(): void {
        this.setLocation(this.getX(), this.getY());
        this.updateCaption(this.getCaption());
        this.xmlNode.isSelected() ? this.markSelected() : this.markUnSelected();
    }

    updateCaption(caption: string) {
        if (this.gCaptionElement) {
            this.gCaptionElement.getHtmlElement().innerHTML = caption;
        } 
    }

    initGSection(section: IGTable): void {
        this.gSection = section;
        this.drawGraphic(section);
        this.update();

       // this.dblClickHandler && this.gSection.dblclick(this.dblClickHandler);
    }

    getCaptionArea(): Area {
        var gCaption = this.gCaptionElement;
        return { 
            x: this.getX() + (gCaption ? gCaption.getBBox().x: 0),
            y: this.getY() + (gCaption ? gCaption.getBBox().y: 0),
            width: gCaption ? gCaption.getBBox().width: 80,
            height: gCaption ? gCaption.getBBox().height: 30
        };
    }

    getGCaption(): IGElement | undefined {
        return this.gCaptionElement;
    }

    initXmlNode(xmlNode: ITagNode) {
        this.xmlNode = xmlNode;
        this.update();
    }

    private update(): void {
        // 定位
       // this.gSection.transformTo(this.getX(), this.getY());
        // 绘制文本
        this.updataView();
    }

    getX(): number {
        return this.ensureGraphicTagNode().getAttributeValueInt(BaseConstants.ATTR_X, 0);
    }

    getY(): number {
        return this.ensureGraphicTagNode().getAttributeValueInt(BaseConstants.ATTR_Y, 0);
    }

    setLocation(x: number, y: number) {
        this.ensureGraphicTagNode().setAttributeValue(BaseConstants.ATTR_X, String(x));
        this.ensureGraphicTagNode().setAttributeValue(BaseConstants.ATTR_Y, String(y));
      //  this.gSection.transformTo(x, y);
    }

    /**
    * 获取选择框绘制范围
    */
    getBounds(): RectBound {
        return {x: this.getX(), y: this.getY(), width: this.getWidth(), height: this.getHeight() };
    }

    /**
     * 获取中心点位置
     * @returns 
     */
    getCenter(): {x: number, y: number} {
        var bounds = this.getBounds();
        var centerX = bounds.x + bounds.width / 2;
        var centerY = bounds.y + bounds.height / 2;
        return {x: centerX, y: centerY};
    }

    getTagNode() {
        return this.xmlNode;
    }

    isSelected(): boolean {
        return this.xmlNode.isSelected();
    }

    hitHtmlElement(el: HTMLElement): boolean {
        return this.gSection.getHtmlElement().contains(el);
    }

    remove(): void {
        this.gSection.remove();
    }

    setOptHandler(handler: (event: MouseEvent) => void): void {
        this.optHandler = handler;
    }

    setOnDblClick(dblclick: (event: MouseEvent) => void): void {
        this.dblClickHandler = dblclick;
    }

    protected getDefaultCaption(): string {
        return I18N.getString(this.getType());
    }

    abstract getSelectSymbo(): IGTable | undefined;

    abstract markSelected(): void;

    abstract markUnSelected(): void;

    abstract drawGraphic(gSection: IGTable): IGTable;
    abstract markHovered(): void;

    abstract markUnHovered(): void;

    protected abstract drawSymbo(): void;

    protected abstract getWidth(): number;

    protected abstract getHeight(): number;

    abstract getType(): string;

    abstract ensureGraphicTagNode(): ITagNode;

    abstract newInstance(xmlNode: ITagNode): AbstractMigrationElement;

}